/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.Script;

public class ListScriptsIterable
implements SdkIterable<ListScriptsResponse> {
    private final GameLiftClient client;
    private final ListScriptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScriptsIterable(GameLiftClient client, ListScriptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListScriptsResponseFetcher();
    }

    public Iterator<ListScriptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Script> scripts() {
        Function<ListScriptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scripts() != null) {
                return response.scripts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScriptsResponseFetcher
    implements SyncPageFetcher<ListScriptsResponse> {
        private ListScriptsResponseFetcher() {
        }

        public boolean hasNextPage(ListScriptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScriptsResponse nextPage(ListScriptsResponse previousPage) {
            if (previousPage == null) {
                return ListScriptsIterable.this.client.listScripts(ListScriptsIterable.this.firstRequest);
            }
            return ListScriptsIterable.this.client.listScripts((ListScriptsRequest)((Object)ListScriptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

