/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.GameServerInstance;

public class DescribeGameServerInstancesPublisher
implements SdkPublisher<DescribeGameServerInstancesResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeGameServerInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGameServerInstancesPublisher(GameLiftAsyncClient client, DescribeGameServerInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGameServerInstancesPublisher(GameLiftAsyncClient client, DescribeGameServerInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGameServerInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGameServerInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameServerInstance> gameServerInstances() {
        Function<DescribeGameServerInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServerInstances() != null) {
                return response.gameServerInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGameServerInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGameServerInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeGameServerInstancesResponse> {
        private DescribeGameServerInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameServerInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeGameServerInstancesResponse> nextPage(DescribeGameServerInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameServerInstancesPublisher.this.client.describeGameServerInstances(DescribeGameServerInstancesPublisher.this.firstRequest);
            }
            return DescribeGameServerInstancesPublisher.this.client.describeGameServerInstances((DescribeGameServerInstancesRequest)((Object)DescribeGameServerInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

