/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.Compute;
import software.amazon.awssdk.services.gamelift.model.ListComputeRequest;
import software.amazon.awssdk.services.gamelift.model.ListComputeResponse;

public class ListComputePublisher
implements SdkPublisher<ListComputeResponse> {
    private final GameLiftAsyncClient client;
    private final ListComputeRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputePublisher(GameLiftAsyncClient client, ListComputeRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputePublisher(GameLiftAsyncClient client, ListComputeRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputeResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputeResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Compute> computeList() {
        Function<ListComputeResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeList() != null) {
                return response.computeList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputeResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputeResponseFetcher
    implements AsyncPageFetcher<ListComputeResponse> {
        private ListComputeResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputeResponse> nextPage(ListComputeResponse previousPage) {
            if (previousPage == null) {
                return ListComputePublisher.this.client.listCompute(ListComputePublisher.this.firstRequest);
            }
            return ListComputePublisher.this.client.listCompute((ListComputeRequest)((Object)ListComputePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

