/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.gamelift.DefaultGameLiftBaseClientBuilder;
import software.amazon.awssdk.services.gamelift.DefaultGameLiftClient;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.GameLiftClientBuilder;
import software.amazon.awssdk.services.gamelift.GameLiftServiceClientConfiguration;
import software.amazon.awssdk.services.gamelift.endpoints.GameLiftEndpointProvider;

@SdkInternalApi
final class DefaultGameLiftClientBuilder
extends DefaultGameLiftBaseClientBuilder<GameLiftClientBuilder, GameLiftClient>
implements GameLiftClientBuilder {
    DefaultGameLiftClientBuilder() {
    }

    @Override
    public DefaultGameLiftClientBuilder endpointProvider(GameLiftEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GameLiftClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGameLiftClientBuilder.validateClientOptions(clientConfiguration);
        GameLiftServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGameLiftClient client = new DefaultGameLiftClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GameLiftServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GameLiftServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

