/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;

public class DescribePlayerSessionsIterable
implements SdkIterable<DescribePlayerSessionsResponse> {
    private final GameLiftClient client;
    private final DescribePlayerSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePlayerSessionsIterable(GameLiftClient client, DescribePlayerSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePlayerSessionsResponseFetcher();
    }

    public Iterator<DescribePlayerSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlayerSession> playerSessions() {
        Function<DescribePlayerSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.playerSessions() != null) {
                return response.playerSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePlayerSessionsResponseFetcher
    implements SyncPageFetcher<DescribePlayerSessionsResponse> {
        private DescribePlayerSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePlayerSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePlayerSessionsResponse nextPage(DescribePlayerSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribePlayerSessionsIterable.this.client.describePlayerSessions(DescribePlayerSessionsIterable.this.firstRequest);
            }
            return DescribePlayerSessionsIterable.this.client.describePlayerSessions((DescribePlayerSessionsRequest)((Object)DescribePlayerSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

