/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerProcess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerProcess> {
    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchPath").getter(ServerProcess.getter(ServerProcess::launchPath)).setter(ServerProcess.setter(Builder::launchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Parameters").getter(ServerProcess.getter(ServerProcess::parameters)).setter(ServerProcess.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<Integer> CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConcurrentExecutions").getter(ServerProcess.getter(ServerProcess::concurrentExecutions)).setter(ServerProcess.setter(Builder::concurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PATH_FIELD, PARAMETERS_FIELD, CONCURRENT_EXECUTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchPath;
    private final String parameters;
    private final Integer concurrentExecutions;

    private ServerProcess(BuilderImpl builder) {
        this.launchPath = builder.launchPath;
        this.parameters = builder.parameters;
        this.concurrentExecutions = builder.concurrentExecutions;
    }

    public final String launchPath() {
        return this.launchPath;
    }

    public final String parameters() {
        return this.parameters;
    }

    public final Integer concurrentExecutions() {
        return this.concurrentExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentExecutions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerProcess)) {
            return false;
        }
        ServerProcess other = (ServerProcess)obj;
        return Objects.equals(this.launchPath(), other.launchPath()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.concurrentExecutions(), other.concurrentExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"ServerProcess").add("LaunchPath", (Object)this.launchPath()).add("Parameters", (Object)this.parameters()).add("ConcurrentExecutions", (Object)this.concurrentExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchPath": {
                return Optional.ofNullable(clazz.cast(this.launchPath()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.concurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerProcess, T> g) {
        return obj -> g.apply((ServerProcess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchPath;
        private String parameters;
        private Integer concurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerProcess model) {
            this.launchPath(model.launchPath);
            this.parameters(model.parameters);
            this.concurrentExecutions(model.concurrentExecutions);
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        @Override
        @Transient
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final String getParameters() {
            return this.parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        @Transient
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        @Override
        @Transient
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public ServerProcess build() {
            return new ServerProcess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerProcess> {
        public Builder launchPath(String var1);

        public Builder parameters(String var1);

        public Builder concurrentExecutions(Integer var1);
    }
}

