/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.BackfillMode;
import software.amazon.awssdk.services.gamelift.model.FlexMatchMode;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.QueueArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchmakingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchmakingConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::name)).setter(MatchmakingConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationArn").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::configurationArn)).setter(MatchmakingConfiguration.setter(Builder::configurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::description)).setter(MatchmakingConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> GAME_SESSION_QUEUE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameSessionQueueArns").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameSessionQueueArns)).setter(MatchmakingConfiguration.setter(Builder::gameSessionQueueArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REQUEST_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestTimeoutSeconds").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::requestTimeoutSeconds)).setter(MatchmakingConfiguration.setter(Builder::requestTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> ACCEPTANCE_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AcceptanceTimeoutSeconds").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::acceptanceTimeoutSeconds)).setter(MatchmakingConfiguration.setter(Builder::acceptanceTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceTimeoutSeconds").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::acceptanceRequired)).setter(MatchmakingConfiguration.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").build()}).build();
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::ruleSetName)).setter(MatchmakingConfiguration.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<String> RULE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetArn").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::ruleSetArn)).setter(MatchmakingConfiguration.setter(Builder::ruleSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetArn").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTarget").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::notificationTarget)).setter(MatchmakingConfiguration.setter(Builder::notificationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTarget").build()}).build();
    private static final SdkField<Integer> ADDITIONAL_PLAYER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AdditionalPlayerCount").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::additionalPlayerCount)).setter(MatchmakingConfiguration.setter(Builder::additionalPlayerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalPlayerCount").build()}).build();
    private static final SdkField<String> CUSTOM_EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomEventData").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::customEventData)).setter(MatchmakingConfiguration.setter(Builder::customEventData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEventData").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::creationTime)).setter(MatchmakingConfiguration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameProperties").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameProperties)).setter(MatchmakingConfiguration.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionData").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameSessionData)).setter(MatchmakingConfiguration.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final SdkField<String> BACKFILL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackfillMode").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::backfillModeAsString)).setter(MatchmakingConfiguration.setter(Builder::backfillMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillMode").build()}).build();
    private static final SdkField<String> FLEX_MATCH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlexMatchMode").getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::flexMatchModeAsString)).setter(MatchmakingConfiguration.setter(Builder::flexMatchMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexMatchMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, GAME_SESSION_QUEUE_ARNS_FIELD, REQUEST_TIMEOUT_SECONDS_FIELD, ACCEPTANCE_TIMEOUT_SECONDS_FIELD, ACCEPTANCE_REQUIRED_FIELD, RULE_SET_NAME_FIELD, RULE_SET_ARN_FIELD, NOTIFICATION_TARGET_FIELD, ADDITIONAL_PLAYER_COUNT_FIELD, CUSTOM_EVENT_DATA_FIELD, CREATION_TIME_FIELD, GAME_PROPERTIES_FIELD, GAME_SESSION_DATA_FIELD, BACKFILL_MODE_FIELD, FLEX_MATCH_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String configurationArn;
    private final String description;
    private final List<String> gameSessionQueueArns;
    private final Integer requestTimeoutSeconds;
    private final Integer acceptanceTimeoutSeconds;
    private final Boolean acceptanceRequired;
    private final String ruleSetName;
    private final String ruleSetArn;
    private final String notificationTarget;
    private final Integer additionalPlayerCount;
    private final String customEventData;
    private final Instant creationTime;
    private final List<GameProperty> gameProperties;
    private final String gameSessionData;
    private final String backfillMode;
    private final String flexMatchMode;

    private MatchmakingConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.configurationArn = builder.configurationArn;
        this.description = builder.description;
        this.gameSessionQueueArns = builder.gameSessionQueueArns;
        this.requestTimeoutSeconds = builder.requestTimeoutSeconds;
        this.acceptanceTimeoutSeconds = builder.acceptanceTimeoutSeconds;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.ruleSetName = builder.ruleSetName;
        this.ruleSetArn = builder.ruleSetArn;
        this.notificationTarget = builder.notificationTarget;
        this.additionalPlayerCount = builder.additionalPlayerCount;
        this.customEventData = builder.customEventData;
        this.creationTime = builder.creationTime;
        this.gameProperties = builder.gameProperties;
        this.gameSessionData = builder.gameSessionData;
        this.backfillMode = builder.backfillMode;
        this.flexMatchMode = builder.flexMatchMode;
    }

    public final String name() {
        return this.name;
    }

    public final String configurationArn() {
        return this.configurationArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGameSessionQueueArns() {
        return this.gameSessionQueueArns != null && !(this.gameSessionQueueArns instanceof SdkAutoConstructList);
    }

    public final List<String> gameSessionQueueArns() {
        return this.gameSessionQueueArns;
    }

    public final Integer requestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public final Integer acceptanceTimeoutSeconds() {
        return this.acceptanceTimeoutSeconds;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final String ruleSetName() {
        return this.ruleSetName;
    }

    public final String ruleSetArn() {
        return this.ruleSetArn;
    }

    public final String notificationTarget() {
        return this.notificationTarget;
    }

    public final Integer additionalPlayerCount() {
        return this.additionalPlayerCount;
    }

    public final String customEventData() {
        return this.customEventData;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasGameProperties() {
        return this.gameProperties != null && !(this.gameProperties instanceof SdkAutoConstructList);
    }

    public final List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public final String gameSessionData() {
        return this.gameSessionData;
    }

    public final BackfillMode backfillMode() {
        return BackfillMode.fromValue(this.backfillMode);
    }

    public final String backfillModeAsString() {
        return this.backfillMode;
    }

    public final FlexMatchMode flexMatchMode() {
        return FlexMatchMode.fromValue(this.flexMatchMode);
    }

    public final String flexMatchModeAsString() {
        return this.flexMatchMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameSessionQueueArns() ? this.gameSessionQueueArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalPlayerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameProperties() ? this.gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfillModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flexMatchModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingConfiguration)) {
            return false;
        }
        MatchmakingConfiguration other = (MatchmakingConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configurationArn(), other.configurationArn()) && Objects.equals(this.description(), other.description()) && this.hasGameSessionQueueArns() == other.hasGameSessionQueueArns() && Objects.equals(this.gameSessionQueueArns(), other.gameSessionQueueArns()) && Objects.equals(this.requestTimeoutSeconds(), other.requestTimeoutSeconds()) && Objects.equals(this.acceptanceTimeoutSeconds(), other.acceptanceTimeoutSeconds()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleSetArn(), other.ruleSetArn()) && Objects.equals(this.notificationTarget(), other.notificationTarget()) && Objects.equals(this.additionalPlayerCount(), other.additionalPlayerCount()) && Objects.equals(this.customEventData(), other.customEventData()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasGameProperties() == other.hasGameProperties() && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.gameSessionData(), other.gameSessionData()) && Objects.equals(this.backfillModeAsString(), other.backfillModeAsString()) && Objects.equals(this.flexMatchModeAsString(), other.flexMatchModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MatchmakingConfiguration").add("Name", (Object)this.name()).add("ConfigurationArn", (Object)this.configurationArn()).add("Description", (Object)this.description()).add("GameSessionQueueArns", this.hasGameSessionQueueArns() ? this.gameSessionQueueArns() : null).add("RequestTimeoutSeconds", (Object)this.requestTimeoutSeconds()).add("AcceptanceTimeoutSeconds", (Object)this.acceptanceTimeoutSeconds()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("RuleSetName", (Object)this.ruleSetName()).add("RuleSetArn", (Object)this.ruleSetArn()).add("NotificationTarget", (Object)this.notificationTarget()).add("AdditionalPlayerCount", (Object)this.additionalPlayerCount()).add("CustomEventData", (Object)this.customEventData()).add("CreationTime", (Object)this.creationTime()).add("GameProperties", this.hasGameProperties() ? this.gameProperties() : null).add("GameSessionData", (Object)this.gameSessionData()).add("BackfillMode", (Object)this.backfillModeAsString()).add("FlexMatchMode", (Object)this.flexMatchModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.configurationArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GameSessionQueueArns": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueueArns()));
            }
            case "RequestTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.requestTimeoutSeconds()));
            }
            case "AcceptanceTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTimeoutSeconds()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "RuleSetArn": {
                return Optional.ofNullable(clazz.cast(this.ruleSetArn()));
            }
            case "NotificationTarget": {
                return Optional.ofNullable(clazz.cast(this.notificationTarget()));
            }
            case "AdditionalPlayerCount": {
                return Optional.ofNullable(clazz.cast(this.additionalPlayerCount()));
            }
            case "CustomEventData": {
                return Optional.ofNullable(clazz.cast(this.customEventData()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
            case "BackfillMode": {
                return Optional.ofNullable(clazz.cast(this.backfillModeAsString()));
            }
            case "FlexMatchMode": {
                return Optional.ofNullable(clazz.cast(this.flexMatchModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchmakingConfiguration, T> g) {
        return obj -> g.apply((MatchmakingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String configurationArn;
        private String description;
        private List<String> gameSessionQueueArns = DefaultSdkAutoConstructList.getInstance();
        private Integer requestTimeoutSeconds;
        private Integer acceptanceTimeoutSeconds;
        private Boolean acceptanceRequired;
        private String ruleSetName;
        private String ruleSetArn;
        private String notificationTarget;
        private Integer additionalPlayerCount;
        private String customEventData;
        private Instant creationTime;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private String gameSessionData;
        private String backfillMode;
        private String flexMatchMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingConfiguration model) {
            this.name(model.name);
            this.configurationArn(model.configurationArn);
            this.description(model.description);
            this.gameSessionQueueArns(model.gameSessionQueueArns);
            this.requestTimeoutSeconds(model.requestTimeoutSeconds);
            this.acceptanceTimeoutSeconds(model.acceptanceTimeoutSeconds);
            this.acceptanceRequired(model.acceptanceRequired);
            this.ruleSetName(model.ruleSetName);
            this.ruleSetArn(model.ruleSetArn);
            this.notificationTarget(model.notificationTarget);
            this.additionalPlayerCount(model.additionalPlayerCount);
            this.customEventData(model.customEventData);
            this.creationTime(model.creationTime);
            this.gameProperties(model.gameProperties);
            this.gameSessionData(model.gameSessionData);
            this.backfillMode(model.backfillMode);
            this.flexMatchMode(model.flexMatchMode);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getConfigurationArn() {
            return this.configurationArn;
        }

        @Override
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getGameSessionQueueArns() {
            if (this.gameSessionQueueArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gameSessionQueueArns;
        }

        @Override
        public final Builder gameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueueArns(String ... gameSessionQueueArns) {
            this.gameSessionQueueArns(Arrays.asList(gameSessionQueueArns));
            return this;
        }

        public final void setGameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
        }

        public final Integer getRequestTimeoutSeconds() {
            return this.requestTimeoutSeconds;
        }

        @Override
        public final Builder requestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return this;
        }

        public final void setRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
        }

        public final Integer getAcceptanceTimeoutSeconds() {
            return this.acceptanceTimeoutSeconds;
        }

        @Override
        public final Builder acceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
            return this;
        }

        public final void setAcceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleSetArn() {
            return this.ruleSetArn;
        }

        @Override
        public final Builder ruleSetArn(String ruleSetArn) {
            this.ruleSetArn = ruleSetArn;
            return this;
        }

        public final void setRuleSetArn(String ruleSetArn) {
            this.ruleSetArn = ruleSetArn;
        }

        public final String getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        public final Integer getAdditionalPlayerCount() {
            return this.additionalPlayerCount;
        }

        @Override
        public final Builder additionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
            return this;
        }

        public final void setAdditionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
        }

        public final String getCustomEventData() {
            return this.customEventData;
        }

        @Override
        public final Builder customEventData(String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        public final void setCustomEventData(String customEventData) {
            this.customEventData = customEventData;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        public final String getBackfillMode() {
            return this.backfillMode;
        }

        @Override
        public final Builder backfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
            return this;
        }

        @Override
        public final Builder backfillMode(BackfillMode backfillMode) {
            this.backfillMode(backfillMode == null ? null : backfillMode.toString());
            return this;
        }

        public final void setBackfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
        }

        public final String getFlexMatchMode() {
            return this.flexMatchMode;
        }

        @Override
        public final Builder flexMatchMode(String flexMatchMode) {
            this.flexMatchMode = flexMatchMode;
            return this;
        }

        @Override
        public final Builder flexMatchMode(FlexMatchMode flexMatchMode) {
            this.flexMatchMode(flexMatchMode == null ? null : flexMatchMode.toString());
            return this;
        }

        public final void setFlexMatchMode(String flexMatchMode) {
            this.flexMatchMode = flexMatchMode;
        }

        public MatchmakingConfiguration build() {
            return new MatchmakingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchmakingConfiguration> {
        public Builder name(String var1);

        public Builder configurationArn(String var1);

        public Builder description(String var1);

        public Builder gameSessionQueueArns(Collection<String> var1);

        public Builder gameSessionQueueArns(String ... var1);

        public Builder requestTimeoutSeconds(Integer var1);

        public Builder acceptanceTimeoutSeconds(Integer var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder ruleSetName(String var1);

        public Builder ruleSetArn(String var1);

        public Builder notificationTarget(String var1);

        public Builder additionalPlayerCount(Integer var1);

        public Builder customEventData(String var1);

        public Builder creationTime(Instant var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder gameSessionData(String var1);

        public Builder backfillMode(String var1);

        public Builder backfillMode(BackfillMode var1);

        public Builder flexMatchMode(String var1);

        public Builder flexMatchMode(FlexMatchMode var1);
    }
}

