/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopFleetActionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StopFleetActionsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(StopFleetActionsRequest.getter(StopFleetActionsRequest::fleetId)).setter(StopFleetActionsRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(StopFleetActionsRequest.getter(StopFleetActionsRequest::actionsAsStrings)).setter(StopFleetActionsRequest.setter(Builder::actionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(StopFleetActionsRequest.getter(StopFleetActionsRequest::location)).setter(StopFleetActionsRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ACTIONS_FIELD, LOCATION_FIELD));
    private final String fleetId;
    private final List<String> actions;
    private final String location;

    private StopFleetActionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.actions = builder.actions;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final List<FleetAction> actions() {
        return FleetActionListCopier.copyStringToEnum(this.actions);
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actionsAsStrings() {
        return this.actions;
    }

    public final String location() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopFleetActionsRequest)) {
            return false;
        }
        StopFleetActionsRequest other = (StopFleetActionsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && this.hasActions() == other.hasActions() && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"StopFleetActionsRequest").add("FleetId", (Object)this.fleetId()).add("Actions", this.hasActions() ? this.actionsAsStrings() : null).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopFleetActionsRequest, T> g) {
        return obj -> g.apply((StopFleetActionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(StopFleetActionsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.actionsWithStrings(model.actions);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        @Transient
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
        }

        @Override
        @Transient
        public final Builder actionsWithStrings(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actionsWithStrings(String ... actions) {
            this.actionsWithStrings(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        public final Builder actions(Collection<FleetAction> actions) {
            this.actions = FleetActionListCopier.copyEnumToString(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(FleetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopFleetActionsRequest build() {
            return new StopFleetActionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopFleetActionsRequest> {
        public Builder fleetId(String var1);

        public Builder actionsWithStrings(Collection<String> var1);

        public Builder actionsWithStrings(String ... var1);

        public Builder actions(Collection<FleetAction> var1);

        public Builder actions(FleetAction ... var1);

        public Builder location(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

