/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameServerInstance;
import software.amazon.awssdk.services.gamelift.model.GameServerInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGameServerInstancesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameServerInstancesResponse> {
    private static final SdkField<List<GameServerInstance>> GAME_SERVER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameServerInstances").getter(DescribeGameServerInstancesResponse.getter(DescribeGameServerInstancesResponse::gameServerInstances)).setter(DescribeGameServerInstancesResponse.setter(Builder::gameServerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameServerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeGameServerInstancesResponse.getter(DescribeGameServerInstancesResponse::nextToken)).setter(DescribeGameServerInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameServerInstance> gameServerInstances;
    private final String nextToken;

    private DescribeGameServerInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.gameServerInstances = builder.gameServerInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGameServerInstances() {
        return this.gameServerInstances != null && !(this.gameServerInstances instanceof SdkAutoConstructList);
    }

    public final List<GameServerInstance> gameServerInstances() {
        return this.gameServerInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameServerInstances() ? this.gameServerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameServerInstancesResponse)) {
            return false;
        }
        DescribeGameServerInstancesResponse other = (DescribeGameServerInstancesResponse)((Object)obj);
        return this.hasGameServerInstances() == other.hasGameServerInstances() && Objects.equals(this.gameServerInstances(), other.gameServerInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGameServerInstancesResponse").add("GameServerInstances", this.hasGameServerInstances() ? this.gameServerInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerInstances": {
                return Optional.ofNullable(clazz.cast(this.gameServerInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameServerInstancesResponse, T> g) {
        return obj -> g.apply((DescribeGameServerInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameServerInstance> gameServerInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameServerInstancesResponse model) {
            super(model);
            this.gameServerInstances(model.gameServerInstances);
            this.nextToken(model.nextToken);
        }

        public final List<GameServerInstance.Builder> getGameServerInstances() {
            List<GameServerInstance.Builder> result = GameServerInstancesCopier.copyToBuilder(this.gameServerInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameServerInstances(Collection<GameServerInstance.BuilderImpl> gameServerInstances) {
            this.gameServerInstances = GameServerInstancesCopier.copyFromBuilder(gameServerInstances);
        }

        @Override
        @Transient
        public final Builder gameServerInstances(Collection<GameServerInstance> gameServerInstances) {
            this.gameServerInstances = GameServerInstancesCopier.copy(gameServerInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gameServerInstances(GameServerInstance ... gameServerInstances) {
            this.gameServerInstances(Arrays.asList(gameServerInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gameServerInstances(Consumer<GameServerInstance.Builder> ... gameServerInstances) {
            this.gameServerInstances(Stream.of(gameServerInstances).map(c -> (GameServerInstance)((GameServerInstance.Builder)GameServerInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeGameServerInstancesResponse build() {
            return new DescribeGameServerInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGameServerInstancesResponse> {
        public Builder gameServerInstances(Collection<GameServerInstance> var1);

        public Builder gameServerInstances(GameServerInstance ... var1);

        public Builder gameServerInstances(Consumer<GameServerInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

