/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameServerGroupAutoScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameServerGroupAutoScalingPolicy> {
    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedInstanceWarmup").getter(GameServerGroupAutoScalingPolicy.getter(GameServerGroupAutoScalingPolicy::estimatedInstanceWarmup)).setter(GameServerGroupAutoScalingPolicy.setter(Builder::estimatedInstanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build()}).build();
    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTrackingConfiguration").getter(GameServerGroupAutoScalingPolicy.getter(GameServerGroupAutoScalingPolicy::targetTrackingConfiguration)).setter(GameServerGroupAutoScalingPolicy.setter(Builder::targetTrackingConfiguration)).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_INSTANCE_WARMUP_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer estimatedInstanceWarmup;
    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private GameServerGroupAutoScalingPolicy(BuilderImpl builder) {
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    public final Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public final TargetTrackingConfiguration targetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServerGroupAutoScalingPolicy)) {
            return false;
        }
        GameServerGroupAutoScalingPolicy other = (GameServerGroupAutoScalingPolicy)obj;
        return Objects.equals(this.estimatedInstanceWarmup(), other.estimatedInstanceWarmup()) && Objects.equals(this.targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GameServerGroupAutoScalingPolicy").add("EstimatedInstanceWarmup", (Object)this.estimatedInstanceWarmup()).add("TargetTrackingConfiguration", (Object)this.targetTrackingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EstimatedInstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.estimatedInstanceWarmup()));
            }
            case "TargetTrackingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameServerGroupAutoScalingPolicy, T> g) {
        return obj -> g.apply((GameServerGroupAutoScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer estimatedInstanceWarmup;
        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServerGroupAutoScalingPolicy model) {
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            this.targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        public GameServerGroupAutoScalingPolicy build() {
            return new GameServerGroupAutoScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameServerGroupAutoScalingPolicy> {
        public Builder estimatedInstanceWarmup(Integer var1);

        public Builder targetTrackingConfiguration(TargetTrackingConfiguration var1);

        default public Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return this.targetTrackingConfiguration((TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)).build());
        }
    }
}

