/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;

public class DescribeFleetAttributesIterable
implements SdkIterable<DescribeFleetAttributesResponse> {
    private final GameLiftClient client;
    private final DescribeFleetAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetAttributesIterable(GameLiftClient client, DescribeFleetAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFleetAttributesResponseFetcher();
    }

    public Iterator<DescribeFleetAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetAttributes> fleetAttributes() {
        Function<DescribeFleetAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetAttributes() != null) {
                return response.fleetAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFleetAttributesResponseFetcher
    implements SyncPageFetcher<DescribeFleetAttributesResponse> {
        private DescribeFleetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetAttributesResponse nextPage(DescribeFleetAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetAttributesIterable.this.client.describeFleetAttributes(DescribeFleetAttributesIterable.this.firstRequest);
            }
            return DescribeFleetAttributesIterable.this.client.describeFleetAttributes((DescribeFleetAttributesRequest)((Object)DescribeFleetAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

