/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuntimeConfigurationRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateRuntimeConfigurationRequest.Builder, UpdateRuntimeConfigurationRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(UpdateRuntimeConfigurationRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<RuntimeConfiguration> RUNTIME_CONFIGURATION_FIELD = SdkField
            .<RuntimeConfiguration> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfiguration")
            .getter(getter(UpdateRuntimeConfigurationRequest::runtimeConfiguration))
            .setter(setter(Builder::runtimeConfiguration)).constructor(RuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            RUNTIME_CONFIGURATION_FIELD));

    private final String fleetId;

    private final RuntimeConfiguration runtimeConfiguration;

    private UpdateRuntimeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.runtimeConfiguration = builder.runtimeConfiguration;
    }

    /**
     * <p>
     * A unique identifier for a fleet to update runtime configuration for. You can use either the fleet ID or ARN
     * value.
     * </p>
     * 
     * @return A unique identifier for a fleet to update runtime configuration for. You can use either the fleet ID or
     *         ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. Server processes run either a custom
     * game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes
     * to run on an instance and includes the following configuration settings: the server executable or launch script
     * file, launch parameters, and the number of processes to run concurrently on each instance. A CreateFleet request
     * must include a runtime configuration with at least one server process configuration.
     * </p>
     * 
     * @return Instructions for launching server processes on each instance in the fleet. Server processes run either a
     *         custom game build executable or a Realtime Servers script. The runtime configuration lists the types of
     *         server processes to run on an instance and includes the following configuration settings: the server
     *         executable or launch script file, launch parameters, and the number of processes to run concurrently on
     *         each instance. A CreateFleet request must include a runtime configuration with at least one server
     *         process configuration.
     */
    public final RuntimeConfiguration runtimeConfiguration() {
        return runtimeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuntimeConfigurationRequest)) {
            return false;
        }
        UpdateRuntimeConfigurationRequest other = (UpdateRuntimeConfigurationRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(runtimeConfiguration(), other.runtimeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuntimeConfigurationRequest").add("FleetId", fleetId())
                .add("RuntimeConfiguration", runtimeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "RuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(runtimeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuntimeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateRuntimeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRuntimeConfigurationRequest> {
        /**
         * <p>
         * A unique identifier for a fleet to update runtime configuration for. You can use either the fleet ID or ARN
         * value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to update runtime configuration for. You can use either the fleet ID
         *        or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Instructions for launching server processes on each instance in the fleet. Server processes run either a
         * custom game build executable or a Realtime Servers script. The runtime configuration lists the types of
         * server processes to run on an instance and includes the following configuration settings: the server
         * executable or launch script file, launch parameters, and the number of processes to run concurrently on each
         * instance. A CreateFleet request must include a runtime configuration with at least one server process
         * configuration.
         * </p>
         * 
         * @param runtimeConfiguration
         *        Instructions for launching server processes on each instance in the fleet. Server processes run either
         *        a custom game build executable or a Realtime Servers script. The runtime configuration lists the types
         *        of server processes to run on an instance and includes the following configuration settings: the
         *        server executable or launch script file, launch parameters, and the number of processes to run
         *        concurrently on each instance. A CreateFleet request must include a runtime configuration with at
         *        least one server process configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration);

        /**
         * <p>
         * Instructions for launching server processes on each instance in the fleet. Server processes run either a
         * custom game build executable or a Realtime Servers script. The runtime configuration lists the types of
         * server processes to run on an instance and includes the following configuration settings: the server
         * executable or launch script file, launch parameters, and the number of processes to run concurrently on each
         * instance. A CreateFleet request must include a runtime configuration with at least one server process
         * configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link RuntimeConfiguration.Builder} avoiding the need
         * to create one manually via {@link RuntimeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuntimeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #runtimeConfiguration(RuntimeConfiguration)}.
         * 
         * @param runtimeConfiguration
         *        a consumer that will call methods on {@link RuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfiguration(RuntimeConfiguration)
         */
        default Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return runtimeConfiguration(RuntimeConfiguration.builder().applyMutation(runtimeConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private RuntimeConfiguration runtimeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuntimeConfigurationRequest model) {
            super(model);
            fleetId(model.fleetId);
            runtimeConfiguration(model.runtimeConfiguration);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return runtimeConfiguration != null ? runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuntimeConfigurationRequest build() {
            return new UpdateRuntimeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
