/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current status of fleet utilization, including the number of game and player sessions being hosted.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListFleets</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StartFleetActions</a> or <a>StopFleetActions</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetUtilization.Builder, FleetUtilization> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(FleetUtilization::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<Integer> ACTIVE_SERVER_PROCESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("ActiveServerProcessCount")
            .getter(getter(FleetUtilization::activeServerProcessCount)).setter(setter(Builder::activeServerProcessCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveServerProcessCount").build())
            .build();

    private static final SdkField<Integer> ACTIVE_GAME_SESSION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveGameSessionCount").getter(getter(FleetUtilization::activeGameSessionCount))
            .setter(setter(Builder::activeGameSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveGameSessionCount").build())
            .build();

    private static final SdkField<Integer> CURRENT_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CurrentPlayerSessionCount")
            .getter(getter(FleetUtilization::currentPlayerSessionCount)).setter(setter(Builder::currentPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPlayerSessionCount").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount")
            .getter(getter(FleetUtilization::maximumPlayerSessionCount)).setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            ACTIVE_SERVER_PROCESS_COUNT_FIELD, ACTIVE_GAME_SESSION_COUNT_FIELD, CURRENT_PLAYER_SESSION_COUNT_FIELD,
            MAXIMUM_PLAYER_SESSION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final Integer activeServerProcessCount;

    private final Integer activeGameSessionCount;

    private final Integer currentPlayerSessionCount;

    private final Integer maximumPlayerSessionCount;

    private FleetUtilization(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.activeServerProcessCount = builder.activeServerProcessCount;
        this.activeGameSessionCount = builder.activeGameSessionCount;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
    }

    /**
     * <p>
     * A unique identifier for a fleet.
     * </p>
     * 
     * @return A unique identifier for a fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the fleet
     * </p>
     * 
     * @return Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the
     *         fleet
     */
    public final Integer activeServerProcessCount() {
        return activeServerProcessCount;
    }

    /**
     * <p>
     * Number of active game sessions currently being hosted on all instances in the fleet.
     * </p>
     * 
     * @return Number of active game sessions currently being hosted on all instances in the fleet.
     */
    public final Integer activeGameSessionCount() {
        return activeGameSessionCount;
    }

    /**
     * <p>
     * Number of active player sessions currently being hosted on all instances in the fleet.
     * </p>
     * 
     * @return Number of active player sessions currently being hosted on all instances in the fleet.
     */
    public final Integer currentPlayerSessionCount() {
        return currentPlayerSessionCount;
    }

    /**
     * <p>
     * The maximum number of players allowed across all game sessions currently being hosted on all instances in the
     * fleet.
     * </p>
     * 
     * @return The maximum number of players allowed across all game sessions currently being hosted on all instances in
     *         the fleet.
     */
    public final Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(activeServerProcessCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeGameSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(currentPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetUtilization)) {
            return false;
        }
        FleetUtilization other = (FleetUtilization) obj;
        return Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(activeServerProcessCount(), other.activeServerProcessCount())
                && Objects.equals(activeGameSessionCount(), other.activeGameSessionCount())
                && Objects.equals(currentPlayerSessionCount(), other.currentPlayerSessionCount())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetUtilization").add("FleetId", fleetId())
                .add("ActiveServerProcessCount", activeServerProcessCount())
                .add("ActiveGameSessionCount", activeGameSessionCount())
                .add("CurrentPlayerSessionCount", currentPlayerSessionCount())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "ActiveServerProcessCount":
            return Optional.ofNullable(clazz.cast(activeServerProcessCount()));
        case "ActiveGameSessionCount":
            return Optional.ofNullable(clazz.cast(activeGameSessionCount()));
        case "CurrentPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(currentPlayerSessionCount()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetUtilization, T> g) {
        return obj -> g.apply((FleetUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetUtilization> {
        /**
         * <p>
         * A unique identifier for a fleet.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the
         * fleet
         * </p>
         * 
         * @param activeServerProcessCount
         *        Number of server processes in an <code>ACTIVE</code> status currently running across all instances in
         *        the fleet
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeServerProcessCount(Integer activeServerProcessCount);

        /**
         * <p>
         * Number of active game sessions currently being hosted on all instances in the fleet.
         * </p>
         * 
         * @param activeGameSessionCount
         *        Number of active game sessions currently being hosted on all instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeGameSessionCount(Integer activeGameSessionCount);

        /**
         * <p>
         * Number of active player sessions currently being hosted on all instances in the fleet.
         * </p>
         * 
         * @param currentPlayerSessionCount
         *        Number of active player sessions currently being hosted on all instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPlayerSessionCount(Integer currentPlayerSessionCount);

        /**
         * <p>
         * The maximum number of players allowed across all game sessions currently being hosted on all instances in the
         * fleet.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        The maximum number of players allowed across all game sessions currently being hosted on all instances
         *        in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private Integer activeServerProcessCount;

        private Integer activeGameSessionCount;

        private Integer currentPlayerSessionCount;

        private Integer maximumPlayerSessionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetUtilization model) {
            fleetId(model.fleetId);
            activeServerProcessCount(model.activeServerProcessCount);
            activeGameSessionCount(model.activeGameSessionCount);
            currentPlayerSessionCount(model.currentPlayerSessionCount);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getActiveServerProcessCount() {
            return activeServerProcessCount;
        }

        @Override
        public final Builder activeServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
            return this;
        }

        public final void setActiveServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
        }

        public final Integer getActiveGameSessionCount() {
            return activeGameSessionCount;
        }

        @Override
        public final Builder activeGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
            return this;
        }

        public final void setActiveGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public FleetUtilization build() {
            return new FleetUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
