/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetUtilizationResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetUtilizationResponse.Builder, DescribeFleetUtilizationResponse> {
    private static final SdkField<List<FleetUtilization>> FLEET_UTILIZATION_FIELD = SdkField
            .<List<FleetUtilization>> builder(MarshallingType.LIST)
            .memberName("FleetUtilization")
            .getter(getter(DescribeFleetUtilizationResponse::fleetUtilization))
            .setter(setter(Builder::fleetUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetUtilization").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetUtilization> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetUtilization::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetUtilizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_UTILIZATION_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FleetUtilization> fleetUtilization;

    private final String nextToken;

    private DescribeFleetUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.fleetUtilization = builder.fleetUtilization;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FleetUtilization property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFleetUtilization() {
        return fleetUtilization != null && !(fleetUtilization instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of objects containing utilization information for each requested fleet ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFleetUtilization()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of objects containing utilization information for each requested fleet ID.
     */
    public final List<FleetUtilization> fleetUtilization() {
        return fleetUtilization;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetUtilization() ? fleetUtilization() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationResponse)) {
            return false;
        }
        DescribeFleetUtilizationResponse other = (DescribeFleetUtilizationResponse) obj;
        return hasFleetUtilization() == other.hasFleetUtilization()
                && Objects.equals(fleetUtilization(), other.fleetUtilization()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetUtilizationResponse")
                .add("FleetUtilization", hasFleetUtilization() ? fleetUtilization() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetUtilization":
            return Optional.ofNullable(clazz.cast(fleetUtilization()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetUtilizationResponse, T> g) {
        return obj -> g.apply((DescribeFleetUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
        /**
         * <p>
         * A collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * 
         * @param fleetUtilization
         *        A collection of objects containing utilization information for each requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization);

        /**
         * <p>
         * A collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * 
         * @param fleetUtilization
         *        A collection of objects containing utilization information for each requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetUtilization(FleetUtilization... fleetUtilization);

        /**
         * <p>
         * A collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetUtilization>.Builder} avoiding the
         * need to create one manually via {@link List<FleetUtilization>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetUtilization>.Builder#build()} is called immediately and
         * its result is passed to {@link #fleetUtilization(List<FleetUtilization>)}.
         * 
         * @param fleetUtilization
         *        a consumer that will call methods on {@link List<FleetUtilization>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetUtilization(List<FleetUtilization>)
         */
        Builder fleetUtilization(Consumer<FleetUtilization.Builder>... fleetUtilization);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<FleetUtilization> fleetUtilization = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationResponse model) {
            super(model);
            fleetUtilization(model.fleetUtilization);
            nextToken(model.nextToken);
        }

        public final Collection<FleetUtilization.Builder> getFleetUtilization() {
            if (fleetUtilization instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetUtilization != null ? fleetUtilization.stream().map(FleetUtilization::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copy(fleetUtilization);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(FleetUtilization... fleetUtilization) {
            fleetUtilization(Arrays.asList(fleetUtilization));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(Consumer<FleetUtilization.Builder>... fleetUtilization) {
            fleetUtilization(Stream.of(fleetUtilization).map(c -> FleetUtilization.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFleetUtilization(Collection<FleetUtilization.BuilderImpl> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copyFromBuilder(fleetUtilization);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetUtilizationResponse build() {
            return new DescribeFleetUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
