/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMatchmakingRuleSetResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateMatchmakingRuleSetResponse.Builder, CreateMatchmakingRuleSetResponse> {
    private static final SdkField<MatchmakingRuleSet> RULE_SET_FIELD = SdkField
            .<MatchmakingRuleSet> builder(MarshallingType.SDK_POJO).memberName("RuleSet")
            .getter(getter(CreateMatchmakingRuleSetResponse::ruleSet)).setter(setter(Builder::ruleSet))
            .constructor(MatchmakingRuleSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_FIELD));

    private final MatchmakingRuleSet ruleSet;

    private CreateMatchmakingRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSet = builder.ruleSet;
    }

    /**
     * <p>
     * The newly created matchmaking rule set.
     * </p>
     * 
     * @return The newly created matchmaking rule set.
     */
    public final MatchmakingRuleSet ruleSet() {
        return ruleSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMatchmakingRuleSetResponse)) {
            return false;
        }
        CreateMatchmakingRuleSetResponse other = (CreateMatchmakingRuleSetResponse) obj;
        return Objects.equals(ruleSet(), other.ruleSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMatchmakingRuleSetResponse").add("RuleSet", ruleSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSet":
            return Optional.ofNullable(clazz.cast(ruleSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMatchmakingRuleSetResponse, T> g) {
        return obj -> g.apply((CreateMatchmakingRuleSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMatchmakingRuleSetResponse> {
        /**
         * <p>
         * The newly created matchmaking rule set.
         * </p>
         * 
         * @param ruleSet
         *        The newly created matchmaking rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSet(MatchmakingRuleSet ruleSet);

        /**
         * <p>
         * The newly created matchmaking rule set.
         * </p>
         * This is a convenience that creates an instance of the {@link MatchmakingRuleSet.Builder} avoiding the need to
         * create one manually via {@link MatchmakingRuleSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link MatchmakingRuleSet.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleSet(MatchmakingRuleSet)}.
         * 
         * @param ruleSet
         *        a consumer that will call methods on {@link MatchmakingRuleSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleSet(MatchmakingRuleSet)
         */
        default Builder ruleSet(Consumer<MatchmakingRuleSet.Builder> ruleSet) {
            return ruleSet(MatchmakingRuleSet.builder().applyMutation(ruleSet).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private MatchmakingRuleSet ruleSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMatchmakingRuleSetResponse model) {
            super(model);
            ruleSet(model.ruleSet);
        }

        public final MatchmakingRuleSet.Builder getRuleSet() {
            return ruleSet != null ? ruleSet.toBuilder() : null;
        }

        @Override
        public final Builder ruleSet(MatchmakingRuleSet ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        public final void setRuleSet(MatchmakingRuleSet.BuilderImpl ruleSet) {
            this.ruleSet = ruleSet != null ? ruleSet.build() : null;
        }

        @Override
        public CreateMatchmakingRuleSetResponse build() {
            return new CreateMatchmakingRuleSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
