/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacedPlayerSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacedPlayerSession> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(PlacedPlayerSession.getter(PlacedPlayerSession::playerId)).setter(PlacedPlayerSession.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> PLAYER_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerSessionId").getter(PlacedPlayerSession.getter(PlacedPlayerSession::playerSessionId)).setter(PlacedPlayerSession.setter(Builder::playerSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD, PLAYER_SESSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String playerId;
    private final String playerSessionId;

    private PlacedPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacedPlayerSession)) {
            return false;
        }
        PlacedPlayerSession other = (PlacedPlayerSession)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerSessionId(), other.playerSessionId());
    }

    public String toString() {
        return ToString.builder((String)"PlacedPlayerSession").add("PlayerId", (Object)this.playerId()).add("PlayerSessionId", (Object)this.playerSessionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerSessionId": {
                return Optional.ofNullable(clazz.cast(this.playerSessionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacedPlayerSession, T> g) {
        return obj -> g.apply((PlacedPlayerSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String playerSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacedPlayerSession model) {
            this.playerId(model.playerId);
            this.playerSessionId(model.playerSessionId);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public PlacedPlayerSession build() {
            return new PlacedPlayerSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacedPlayerSession> {
        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);
    }
}

