/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameServerGroup;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGameServerGroupsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListGameServerGroupsResponse> {
    private static final SdkField<List<GameServerGroup>> GAME_SERVER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameServerGroups").getter(ListGameServerGroupsResponse.getter(ListGameServerGroupsResponse::gameServerGroups)).setter(ListGameServerGroupsResponse.setter(Builder::gameServerGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameServerGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGameServerGroupsResponse.getter(ListGameServerGroupsResponse::nextToken)).setter(ListGameServerGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameServerGroup> gameServerGroups;
    private final String nextToken;

    private ListGameServerGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.gameServerGroups = builder.gameServerGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGameServerGroups() {
        return this.gameServerGroups != null && !(this.gameServerGroups instanceof SdkAutoConstructList);
    }

    public List<GameServerGroup> gameServerGroups() {
        return this.gameServerGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameServerGroups() ? this.gameServerGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGameServerGroupsResponse)) {
            return false;
        }
        ListGameServerGroupsResponse other = (ListGameServerGroupsResponse)((Object)obj);
        return this.hasGameServerGroups() == other.hasGameServerGroups() && Objects.equals(this.gameServerGroups(), other.gameServerGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGameServerGroupsResponse").add("GameServerGroups", this.hasGameServerGroups() ? this.gameServerGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroups": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGameServerGroupsResponse, T> g) {
        return obj -> g.apply((ListGameServerGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameServerGroup> gameServerGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGameServerGroupsResponse model) {
            super(model);
            this.gameServerGroups(model.gameServerGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameServerGroup.Builder> getGameServerGroups() {
            if (this.gameServerGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gameServerGroups != null ? (Collection)this.gameServerGroups.stream().map(GameServerGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameServerGroups(Collection<GameServerGroup> gameServerGroups) {
            this.gameServerGroups = GameServerGroupsCopier.copy(gameServerGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameServerGroups(GameServerGroup ... gameServerGroups) {
            this.gameServerGroups(Arrays.asList(gameServerGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameServerGroups(Consumer<GameServerGroup.Builder> ... gameServerGroups) {
            this.gameServerGroups(Stream.of(gameServerGroups).map(c -> (GameServerGroup)((GameServerGroup.Builder)GameServerGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameServerGroups(Collection<GameServerGroup.BuilderImpl> gameServerGroups) {
            this.gameServerGroups = GameServerGroupsCopier.copyFromBuilder(gameServerGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGameServerGroupsResponse build() {
            return new ListGameServerGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGameServerGroupsResponse> {
        public Builder gameServerGroups(Collection<GameServerGroup> var1);

        public Builder gameServerGroups(GameServerGroup ... var1);

        public Builder gameServerGroups(Consumer<GameServerGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

