/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DesiredPlayerSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DesiredPlayerSession> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(DesiredPlayerSession.getter(DesiredPlayerSession::playerId)).setter(DesiredPlayerSession.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> PLAYER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerData").getter(DesiredPlayerSession.getter(DesiredPlayerSession::playerData)).setter(DesiredPlayerSession.setter(Builder::playerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD, PLAYER_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String playerId;
    private final String playerData;

    private DesiredPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredPlayerSession)) {
            return false;
        }
        DesiredPlayerSession other = (DesiredPlayerSession)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerData(), other.playerData());
    }

    public String toString() {
        return ToString.builder((String)"DesiredPlayerSession").add("PlayerId", (Object)this.playerId()).add("PlayerData", (Object)this.playerData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerData": {
                return Optional.ofNullable(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DesiredPlayerSession, T> g) {
        return obj -> g.apply((DesiredPlayerSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredPlayerSession model) {
            this.playerId(model.playerId);
            this.playerData(model.playerData);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public DesiredPlayerSession build() {
            return new DesiredPlayerSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DesiredPlayerSession> {
        public Builder playerId(String var1);

        public Builder playerData(String var1);
    }
}

