/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFleetActionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StartFleetActionsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(StartFleetActionsRequest.getter(StartFleetActionsRequest::fleetId)).setter(StartFleetActionsRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(StartFleetActionsRequest.getter(StartFleetActionsRequest::actionsAsStrings)).setter(StartFleetActionsRequest.setter(Builder::actionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ACTIONS_FIELD));
    private final String fleetId;
    private final List<String> actions;

    private StartFleetActionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.actions = builder.actions;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public List<FleetAction> actions() {
        return FleetActionListCopier.copyStringToEnum(this.actions);
    }

    public boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public List<String> actionsAsStrings() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFleetActionsRequest)) {
            return false;
        }
        StartFleetActionsRequest other = (StartFleetActionsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"StartFleetActionsRequest").add("FleetId", (Object)this.fleetId()).add("Actions", this.actionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFleetActionsRequest, T> g) {
        return obj -> g.apply((StartFleetActionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartFleetActionsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.actionsWithStrings(model.actions);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<String> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actionsWithStrings(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsWithStrings(String ... actions) {
            this.actionsWithStrings(Arrays.asList(actions));
            return this;
        }

        @Override
        public final Builder actions(Collection<FleetAction> actions) {
            this.actions = FleetActionListCopier.copyEnumToString(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(FleetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFleetActionsRequest build() {
            return new StartFleetActionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFleetActionsRequest> {
        public Builder fleetId(String var1);

        public Builder actionsWithStrings(Collection<String> var1);

        public Builder actionsWithStrings(String ... var1);

        public Builder actions(Collection<FleetAction> var1);

        public Builder actions(FleetAction ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

