/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerHealthCheck;
import software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameServerRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameServerRequest.getter(UpdateGameServerRequest::gameServerGroupName)).setter(UpdateGameServerRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameServerRequest.getter(UpdateGameServerRequest::gameServerId)).setter(UpdateGameServerRequest.setter(Builder::gameServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()}).build();
    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameServerRequest.getter(UpdateGameServerRequest::gameServerData)).setter(UpdateGameServerRequest.setter(Builder::gameServerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()}).build();
    private static final SdkField<String> UTILIZATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameServerRequest.getter(UpdateGameServerRequest::utilizationStatusAsString)).setter(UpdateGameServerRequest.setter(Builder::utilizationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationStatus").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameServerRequest.getter(UpdateGameServerRequest::healthCheckAsString)).setter(UpdateGameServerRequest.setter(Builder::healthCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_ID_FIELD, GAME_SERVER_DATA_FIELD, UTILIZATION_STATUS_FIELD, HEALTH_CHECK_FIELD));
    private final String gameServerGroupName;
    private final String gameServerId;
    private final String gameServerData;
    private final String utilizationStatus;
    private final String healthCheck;

    private UpdateGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.gameServerData = builder.gameServerData;
        this.utilizationStatus = builder.utilizationStatus;
        this.healthCheck = builder.healthCheck;
    }

    public String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public String gameServerId() {
        return this.gameServerId;
    }

    public String gameServerData() {
        return this.gameServerData;
    }

    public GameServerUtilizationStatus utilizationStatus() {
        return GameServerUtilizationStatus.fromValue(this.utilizationStatus);
    }

    public String utilizationStatusAsString() {
        return this.utilizationStatus;
    }

    public GameServerHealthCheck healthCheck() {
        return GameServerHealthCheck.fromValue(this.healthCheck);
    }

    public String healthCheckAsString() {
        return this.healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameServerRequest)) {
            return false;
        }
        UpdateGameServerRequest other = (UpdateGameServerRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerId(), other.gameServerId()) && Objects.equals(this.gameServerData(), other.gameServerData()) && Objects.equals(this.utilizationStatusAsString(), other.utilizationStatusAsString()) && Objects.equals(this.healthCheckAsString(), other.healthCheckAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGameServerRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerId", (Object)this.gameServerId()).add("GameServerData", (Object)this.gameServerData()).add("UtilizationStatus", (Object)this.utilizationStatusAsString()).add("HealthCheck", (Object)this.healthCheckAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerId": {
                return Optional.ofNullable(clazz.cast(this.gameServerId()));
            }
            case "GameServerData": {
                return Optional.ofNullable(clazz.cast(this.gameServerData()));
            }
            case "UtilizationStatus": {
                return Optional.ofNullable(clazz.cast(this.utilizationStatusAsString()));
            }
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheckAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameServerRequest, T> g) {
        return obj -> g.apply((UpdateGameServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerId;
        private String gameServerData;
        private String utilizationStatus;
        private String healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameServerRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerId(model.gameServerId);
            this.gameServerData(model.gameServerData);
            this.utilizationStatus(model.utilizationStatus);
            this.healthCheck(model.healthCheck);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final String getGameServerId() {
            return this.gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        public final String getGameServerData() {
            return this.gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        public final String getUtilizationStatus() {
            return this.utilizationStatus;
        }

        @Override
        public final Builder utilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
            return this;
        }

        @Override
        public final Builder utilizationStatus(GameServerUtilizationStatus utilizationStatus) {
            this.utilizationStatus(utilizationStatus == null ? null : utilizationStatus.toString());
            return this;
        }

        public final void setUtilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
        }

        public final String getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final Builder healthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        @Override
        public final Builder healthCheck(GameServerHealthCheck healthCheck) {
            this.healthCheck(healthCheck == null ? null : healthCheck.toString());
            return this;
        }

        public final void setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameServerRequest build() {
            return new UpdateGameServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGameServerRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerId(String var1);

        public Builder gameServerData(String var1);

        public Builder utilizationStatus(String var1);

        public Builder utilizationStatus(GameServerUtilizationStatus var1);

        public Builder healthCheck(String var1);

        public Builder healthCheck(GameServerHealthCheck var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

