/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus;
import software.amazon.awssdk.services.gamelift.model.GameServerUtilizationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameServer> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::gameServerGroupName)).setter(GameServer.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::gameServerGroupArn)).setter(GameServer.setter(Builder::gameServerGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupArn").build()}).build();
    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::gameServerId)).setter(GameServer.setter(Builder::gameServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::instanceId)).setter(GameServer.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::connectionInfo)).setter(GameServer.setter(Builder::connectionInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInfo").build()}).build();
    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::gameServerData)).setter(GameServer.setter(Builder::gameServerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()}).build();
    private static final SdkField<String> CUSTOM_SORT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::customSortKey)).setter(GameServer.setter(Builder::customSortKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSortKey").build()}).build();
    private static final SdkField<String> CLAIM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::claimStatusAsString)).setter(GameServer.setter(Builder::claimStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimStatus").build()}).build();
    private static final SdkField<String> UTILIZATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameServer.getter(GameServer::utilizationStatusAsString)).setter(GameServer.setter(Builder::utilizationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationStatus").build()}).build();
    private static final SdkField<Instant> REGISTRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GameServer.getter(GameServer::registrationTime)).setter(GameServer.setter(Builder::registrationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTime").build()}).build();
    private static final SdkField<Instant> LAST_CLAIM_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GameServer.getter(GameServer::lastClaimTime)).setter(GameServer.setter(Builder::lastClaimTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastClaimTime").build()}).build();
    private static final SdkField<Instant> LAST_HEALTH_CHECK_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GameServer.getter(GameServer::lastHealthCheckTime)).setter(GameServer.setter(Builder::lastHealthCheckTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastHealthCheckTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_GROUP_ARN_FIELD, GAME_SERVER_ID_FIELD, INSTANCE_ID_FIELD, CONNECTION_INFO_FIELD, GAME_SERVER_DATA_FIELD, CUSTOM_SORT_KEY_FIELD, CLAIM_STATUS_FIELD, UTILIZATION_STATUS_FIELD, REGISTRATION_TIME_FIELD, LAST_CLAIM_TIME_FIELD, LAST_HEALTH_CHECK_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gameServerGroupName;
    private final String gameServerGroupArn;
    private final String gameServerId;
    private final String instanceId;
    private final String connectionInfo;
    private final String gameServerData;
    private final String customSortKey;
    private final String claimStatus;
    private final String utilizationStatus;
    private final Instant registrationTime;
    private final Instant lastClaimTime;
    private final Instant lastHealthCheckTime;

    private GameServer(BuilderImpl builder) {
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerGroupArn = builder.gameServerGroupArn;
        this.gameServerId = builder.gameServerId;
        this.instanceId = builder.instanceId;
        this.connectionInfo = builder.connectionInfo;
        this.gameServerData = builder.gameServerData;
        this.customSortKey = builder.customSortKey;
        this.claimStatus = builder.claimStatus;
        this.utilizationStatus = builder.utilizationStatus;
        this.registrationTime = builder.registrationTime;
        this.lastClaimTime = builder.lastClaimTime;
        this.lastHealthCheckTime = builder.lastHealthCheckTime;
    }

    public String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public String gameServerGroupArn() {
        return this.gameServerGroupArn;
    }

    public String gameServerId() {
        return this.gameServerId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String connectionInfo() {
        return this.connectionInfo;
    }

    public String gameServerData() {
        return this.gameServerData;
    }

    public String customSortKey() {
        return this.customSortKey;
    }

    public GameServerClaimStatus claimStatus() {
        return GameServerClaimStatus.fromValue(this.claimStatus);
    }

    public String claimStatusAsString() {
        return this.claimStatus;
    }

    public GameServerUtilizationStatus utilizationStatus() {
        return GameServerUtilizationStatus.fromValue(this.utilizationStatus);
    }

    public String utilizationStatusAsString() {
        return this.utilizationStatus;
    }

    public Instant registrationTime() {
        return this.registrationTime;
    }

    public Instant lastClaimTime() {
        return this.lastClaimTime;
    }

    public Instant lastHealthCheckTime() {
        return this.lastHealthCheckTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSortKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastClaimTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastHealthCheckTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServer)) {
            return false;
        }
        GameServer other = (GameServer)obj;
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerGroupArn(), other.gameServerGroupArn()) && Objects.equals(this.gameServerId(), other.gameServerId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.connectionInfo(), other.connectionInfo()) && Objects.equals(this.gameServerData(), other.gameServerData()) && Objects.equals(this.customSortKey(), other.customSortKey()) && Objects.equals(this.claimStatusAsString(), other.claimStatusAsString()) && Objects.equals(this.utilizationStatusAsString(), other.utilizationStatusAsString()) && Objects.equals(this.registrationTime(), other.registrationTime()) && Objects.equals(this.lastClaimTime(), other.lastClaimTime()) && Objects.equals(this.lastHealthCheckTime(), other.lastHealthCheckTime());
    }

    public String toString() {
        return ToString.builder((String)"GameServer").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerGroupArn", (Object)this.gameServerGroupArn()).add("GameServerId", (Object)this.gameServerId()).add("InstanceId", (Object)this.instanceId()).add("ConnectionInfo", (Object)this.connectionInfo()).add("GameServerData", (Object)this.gameServerData()).add("CustomSortKey", (Object)this.customSortKey()).add("ClaimStatus", (Object)this.claimStatusAsString()).add("UtilizationStatus", (Object)this.utilizationStatusAsString()).add("RegistrationTime", (Object)this.registrationTime()).add("LastClaimTime", (Object)this.lastClaimTime()).add("LastHealthCheckTime", (Object)this.lastHealthCheckTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerGroupArn": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupArn()));
            }
            case "GameServerId": {
                return Optional.ofNullable(clazz.cast(this.gameServerId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.connectionInfo()));
            }
            case "GameServerData": {
                return Optional.ofNullable(clazz.cast(this.gameServerData()));
            }
            case "CustomSortKey": {
                return Optional.ofNullable(clazz.cast(this.customSortKey()));
            }
            case "ClaimStatus": {
                return Optional.ofNullable(clazz.cast(this.claimStatusAsString()));
            }
            case "UtilizationStatus": {
                return Optional.ofNullable(clazz.cast(this.utilizationStatusAsString()));
            }
            case "RegistrationTime": {
                return Optional.ofNullable(clazz.cast(this.registrationTime()));
            }
            case "LastClaimTime": {
                return Optional.ofNullable(clazz.cast(this.lastClaimTime()));
            }
            case "LastHealthCheckTime": {
                return Optional.ofNullable(clazz.cast(this.lastHealthCheckTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameServer, T> g) {
        return obj -> g.apply((GameServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerGroupArn;
        private String gameServerId;
        private String instanceId;
        private String connectionInfo;
        private String gameServerData;
        private String customSortKey;
        private String claimStatus;
        private String utilizationStatus;
        private Instant registrationTime;
        private Instant lastClaimTime;
        private Instant lastHealthCheckTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServer model) {
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerGroupArn(model.gameServerGroupArn);
            this.gameServerId(model.gameServerId);
            this.instanceId(model.instanceId);
            this.connectionInfo(model.connectionInfo);
            this.gameServerData(model.gameServerData);
            this.customSortKey(model.customSortKey);
            this.claimStatus(model.claimStatus);
            this.utilizationStatus(model.utilizationStatus);
            this.registrationTime(model.registrationTime);
            this.lastClaimTime(model.lastClaimTime);
            this.lastHealthCheckTime(model.lastHealthCheckTime);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final String getGameServerGroupArn() {
            return this.gameServerGroupArn;
        }

        @Override
        public final Builder gameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
            return this;
        }

        public final void setGameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
        }

        public final String getGameServerId() {
            return this.gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getConnectionInfo() {
            return this.connectionInfo;
        }

        @Override
        public final Builder connectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public final void setConnectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
        }

        public final String getGameServerData() {
            return this.gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        public final String getCustomSortKey() {
            return this.customSortKey;
        }

        @Override
        public final Builder customSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
            return this;
        }

        public final void setCustomSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
        }

        public final String getClaimStatusAsString() {
            return this.claimStatus;
        }

        @Override
        public final Builder claimStatus(String claimStatus) {
            this.claimStatus = claimStatus;
            return this;
        }

        @Override
        public final Builder claimStatus(GameServerClaimStatus claimStatus) {
            this.claimStatus(claimStatus == null ? null : claimStatus.toString());
            return this;
        }

        public final void setClaimStatus(String claimStatus) {
            this.claimStatus = claimStatus;
        }

        public final String getUtilizationStatusAsString() {
            return this.utilizationStatus;
        }

        @Override
        public final Builder utilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
            return this;
        }

        @Override
        public final Builder utilizationStatus(GameServerUtilizationStatus utilizationStatus) {
            this.utilizationStatus(utilizationStatus == null ? null : utilizationStatus.toString());
            return this;
        }

        public final void setUtilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
        }

        public final Instant getRegistrationTime() {
            return this.registrationTime;
        }

        @Override
        public final Builder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public final void setRegistrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
        }

        public final Instant getLastClaimTime() {
            return this.lastClaimTime;
        }

        @Override
        public final Builder lastClaimTime(Instant lastClaimTime) {
            this.lastClaimTime = lastClaimTime;
            return this;
        }

        public final void setLastClaimTime(Instant lastClaimTime) {
            this.lastClaimTime = lastClaimTime;
        }

        public final Instant getLastHealthCheckTime() {
            return this.lastHealthCheckTime;
        }

        @Override
        public final Builder lastHealthCheckTime(Instant lastHealthCheckTime) {
            this.lastHealthCheckTime = lastHealthCheckTime;
            return this;
        }

        public final void setLastHealthCheckTime(Instant lastHealthCheckTime) {
            this.lastHealthCheckTime = lastHealthCheckTime;
        }

        public GameServer build() {
            return new GameServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameServer> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerGroupArn(String var1);

        public Builder gameServerId(String var1);

        public Builder instanceId(String var1);

        public Builder connectionInfo(String var1);

        public Builder gameServerData(String var1);

        public Builder customSortKey(String var1);

        public Builder claimStatus(String var1);

        public Builder claimStatus(GameServerClaimStatus var1);

        public Builder utilizationStatus(String var1);

        public Builder utilizationStatus(GameServerUtilizationStatus var1);

        public Builder registrationTime(Instant var1);

        public Builder lastClaimTime(Instant var1);

        public Builder lastHealthCheckTime(Instant var1);
    }
}

