/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetail;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGameSessionDetailsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionDetailsResponse> {
    private static final SdkField<List<GameSessionDetail>> GAME_SESSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGameSessionDetailsResponse.getter(DescribeGameSessionDetailsResponse::gameSessionDetails)).setter(DescribeGameSessionDetailsResponse.setter(Builder::gameSessionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSessionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGameSessionDetailsResponse.getter(DescribeGameSessionDetailsResponse::nextToken)).setter(DescribeGameSessionDetailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameSessionDetail> gameSessionDetails;
    private final String nextToken;

    private DescribeGameSessionDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionDetails = builder.gameSessionDetails;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGameSessionDetails() {
        return this.gameSessionDetails != null && !(this.gameSessionDetails instanceof SdkAutoConstructList);
    }

    public List<GameSessionDetail> gameSessionDetails() {
        return this.gameSessionDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionDetailsResponse)) {
            return false;
        }
        DescribeGameSessionDetailsResponse other = (DescribeGameSessionDetailsResponse)((Object)obj);
        return Objects.equals(this.gameSessionDetails(), other.gameSessionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGameSessionDetailsResponse").add("GameSessionDetails", this.gameSessionDetails()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionDetails": {
                return Optional.ofNullable(clazz.cast(this.gameSessionDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionDetailsResponse, T> g) {
        return obj -> g.apply((DescribeGameSessionDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSessionDetail> gameSessionDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionDetailsResponse model) {
            super(model);
            this.gameSessionDetails(model.gameSessionDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameSessionDetail.Builder> getGameSessionDetails() {
            return this.gameSessionDetails != null ? (Collection)this.gameSessionDetails.stream().map(GameSessionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessionDetails(Collection<GameSessionDetail> gameSessionDetails) {
            this.gameSessionDetails = GameSessionDetailListCopier.copy(gameSessionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionDetails(GameSessionDetail ... gameSessionDetails) {
            this.gameSessionDetails(Arrays.asList(gameSessionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionDetails(Consumer<GameSessionDetail.Builder> ... gameSessionDetails) {
            this.gameSessionDetails(Stream.of(gameSessionDetails).map(c -> (GameSessionDetail)((GameSessionDetail.Builder)GameSessionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameSessionDetails(Collection<GameSessionDetail.BuilderImpl> gameSessionDetails) {
            this.gameSessionDetails = GameSessionDetailListCopier.copyFromBuilder(gameSessionDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGameSessionDetailsResponse build() {
            return new DescribeGameSessionDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGameSessionDetailsResponse> {
        public Builder gameSessionDetails(Collection<GameSessionDetail> var1);

        public Builder gameSessionDetails(GameSessionDetail ... var1);

        public Builder gameSessionDetails(Consumer<GameSessionDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

