/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameSessionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameSessionDetail> {
    private static final SdkField<GameSession> GAME_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GameSessionDetail.getter(GameSessionDetail::gameSession)).setter(GameSessionDetail.setter(Builder::gameSession)).constructor(GameSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSession").build()}).build();
    private static final SdkField<String> PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSessionDetail.getter(GameSessionDetail::protectionPolicyAsString)).setter(GameSessionDetail.setter(Builder::protectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_FIELD, PROTECTION_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final GameSession gameSession;
    private final String protectionPolicy;

    private GameSessionDetail(BuilderImpl builder) {
        this.gameSession = builder.gameSession;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public GameSession gameSession() {
        return this.gameSession;
    }

    public ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(this.protectionPolicy);
    }

    public String protectionPolicyAsString() {
        return this.protectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionPolicyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionDetail)) {
            return false;
        }
        GameSessionDetail other = (GameSessionDetail)obj;
        return Objects.equals(this.gameSession(), other.gameSession()) && Objects.equals(this.protectionPolicyAsString(), other.protectionPolicyAsString());
    }

    public String toString() {
        return ToString.builder((String)"GameSessionDetail").add("GameSession", (Object)this.gameSession()).add("ProtectionPolicy", (Object)this.protectionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSession": {
                return Optional.ofNullable(clazz.cast(this.gameSession()));
            }
            case "ProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.protectionPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameSessionDetail, T> g) {
        return obj -> g.apply((GameSessionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GameSession gameSession;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionDetail model) {
            this.gameSession(model.gameSession);
            this.protectionPolicy(model.protectionPolicy);
        }

        public final GameSession.Builder getGameSession() {
            return this.gameSession != null ? this.gameSession.toBuilder() : null;
        }

        @Override
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        public final void setGameSession(GameSession.BuilderImpl gameSession) {
            this.gameSession = gameSession != null ? gameSession.build() : null;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy == null ? null : protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        public GameSessionDetail build() {
            return new GameSessionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameSessionDetail> {
        public Builder gameSession(GameSession var1);

        default public Builder gameSession(Consumer<GameSession.Builder> gameSession) {
            return this.gameSession((GameSession)((GameSession.Builder)GameSession.builder().applyMutation(gameSession)).build());
        }

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);
    }
}

