/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricName {
    ACTIVATING_GAME_SESSIONS("ActivatingGameSessions"),
    ACTIVE_GAME_SESSIONS("ActiveGameSessions"),
    ACTIVE_INSTANCES("ActiveInstances"),
    AVAILABLE_GAME_SESSIONS("AvailableGameSessions"),
    AVAILABLE_PLAYER_SESSIONS("AvailablePlayerSessions"),
    CURRENT_PLAYER_SESSIONS("CurrentPlayerSessions"),
    IDLE_INSTANCES("IdleInstances"),
    PERCENT_AVAILABLE_GAME_SESSIONS("PercentAvailableGameSessions"),
    PERCENT_IDLE_INSTANCES("PercentIdleInstances"),
    QUEUE_DEPTH("QueueDepth"),
    WAIT_TIME("WaitTime"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        return Stream.of(MetricName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

