/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerDataMapCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlayerSessionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionsRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePlayerSessionsRequest.getter(CreatePlayerSessionsRequest::gameSessionId)).setter(CreatePlayerSessionsRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<List<String>> PLAYER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreatePlayerSessionsRequest.getter(CreatePlayerSessionsRequest::playerIds)).setter(CreatePlayerSessionsRequest.setter(Builder::playerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PLAYER_DATA_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreatePlayerSessionsRequest.getter(CreatePlayerSessionsRequest::playerDataMap)).setter(CreatePlayerSessionsRequest.setter(Builder::playerDataMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerDataMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, PLAYER_IDS_FIELD, PLAYER_DATA_MAP_FIELD));
    private final String gameSessionId;
    private final List<String> playerIds;
    private final Map<String, String> playerDataMap;

    private CreatePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerIds = builder.playerIds;
        this.playerDataMap = builder.playerDataMap;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public List<String> playerIds() {
        return this.playerIds;
    }

    public Map<String, String> playerDataMap() {
        return this.playerDataMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerDataMap());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsRequest)) {
            return false;
        }
        CreatePlayerSessionsRequest other = (CreatePlayerSessionsRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerIds(), other.playerIds()) && Objects.equals(this.playerDataMap(), other.playerDataMap());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlayerSessionsRequest").add("GameSessionId", (Object)this.gameSessionId()).add("PlayerIds", this.playerIds()).add("PlayerDataMap", this.playerDataMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "PlayerIds": {
                return Optional.ofNullable(clazz.cast(this.playerIds()));
            }
            case "PlayerDataMap": {
                return Optional.ofNullable(clazz.cast(this.playerDataMap()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlayerSessionsRequest, T> g) {
        return obj -> g.apply((CreatePlayerSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private List<String> playerIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> playerDataMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.playerIds(model.playerIds);
            this.playerDataMap(model.playerDataMap);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Collection<String> getPlayerIds() {
            return this.playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String ... playerIds) {
            this.playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
        }

        public final Map<String, String> getPlayerDataMap() {
            return this.playerDataMap;
        }

        @Override
        public final Builder playerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
            return this;
        }

        public final void setPlayerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionsRequest build() {
            return new CreatePlayerSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerIds(Collection<String> var1);

        public Builder playerIds(String ... var1);

        public Builder playerDataMap(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

