/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchResponse;
import software.amazon.awssdk.services.gamelift.model.ConflictException;
import software.amazon.awssdk.services.gamelift.model.CreateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.CreateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.CreateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.CreateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityExceededException;
import software.amazon.awssdk.services.gamelift.model.GameLiftException;
import software.amazon.awssdk.services.gamelift.model.GameSessionFullException;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse;
import software.amazon.awssdk.services.gamelift.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.gamelift.model.InternalServiceException;
import software.amazon.awssdk.services.gamelift.model.InvalidFleetStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidGameSessionStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidRequestException;
import software.amazon.awssdk.services.gamelift.model.LimitExceededException;
import software.amazon.awssdk.services.gamelift.model.ListAliasesRequest;
import software.amazon.awssdk.services.gamelift.model.ListAliasesResponse;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.NotFoundException;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.TerminalRoutingStrategyException;
import software.amazon.awssdk.services.gamelift.model.UnauthorizedException;
import software.amazon.awssdk.services.gamelift.model.UnsupportedRegionException;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.transform.AcceptMatchRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeEc2InstanceLimitsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetEventsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetUtilizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionDetailsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionQueuesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeScalingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetGameSessionLogUrlRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetInstanceAccessRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RequestUploadCredentialsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ResolveAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.SearchGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchBackfillRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ValidateMatchmakingRuleSetRequestMarshaller;

@SdkInternalApi
final class DefaultGameLiftClient
implements GameLiftClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGameLiftClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "gamelift";
    }

    @Override
    public AcceptMatchResponse acceptMatch(AcceptMatchRequest acceptMatchRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptMatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AcceptMatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptMatchRequest).withMarshaller((Marshaller)new AcceptMatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws UnauthorizedException, InvalidRequestException, ConflictException, InternalServiceException, LimitExceededException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBuildResponse createBuild(CreateBuildRequest createBuildRequest) throws UnauthorizedException, InvalidRequestException, ConflictException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBuildRequest).withMarshaller((Marshaller)new CreateBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InternalServiceException, NotFoundException, ConflictException, LimitExceededException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFleetRequest).withMarshaller((Marshaller)new CreateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGameSessionResponse createGameSession(CreateGameSessionRequest createGameSessionRequest) throws ConflictException, InternalServiceException, UnauthorizedException, InvalidFleetStatusException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, FleetCapacityExceededException, LimitExceededException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGameSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameSessionRequest).withMarshaller((Marshaller)new CreateGameSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGameSessionQueueResponse createGameSessionQueue(CreateGameSessionQueueRequest createGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, LimitExceededException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGameSessionQueueRequest).withMarshaller((Marshaller)new CreateGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateMatchmakingConfigurationResponse createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest createMatchmakingConfigurationRequest) throws InvalidRequestException, LimitExceededException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMatchmakingConfigurationRequest).withMarshaller((Marshaller)new CreateMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateMatchmakingRuleSetResponse createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest createMatchmakingRuleSetRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMatchmakingRuleSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateMatchmakingRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMatchmakingRuleSetRequest).withMarshaller((Marshaller)new CreateMatchmakingRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePlayerSessionResponse createPlayerSession(CreatePlayerSessionRequest createPlayerSessionRequest) throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePlayerSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePlayerSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlayerSessionRequest).withMarshaller((Marshaller)new CreatePlayerSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePlayerSessionsResponse createPlayerSessions(CreatePlayerSessionsRequest createPlayerSessionsRequest) throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePlayerSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePlayerSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlayerSessionsRequest).withMarshaller((Marshaller)new CreatePlayerSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateVpcPeeringAuthorizationResponse createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest createVpcPeeringAuthorizationRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcPeeringAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateVpcPeeringAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcPeeringAuthorizationRequest).withMarshaller((Marshaller)new CreateVpcPeeringAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateVpcPeeringConnectionResponse createVpcPeeringConnection(CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcPeeringConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateVpcPeeringConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcPeeringConnectionRequest).withMarshaller((Marshaller)new CreateVpcPeeringConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws UnauthorizedException, NotFoundException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBuildResponse deleteBuild(DeleteBuildRequest deleteBuildRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBuildRequest).withMarshaller((Marshaller)new DeleteBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws NotFoundException, InternalServiceException, InvalidFleetStatusException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFleetRequest).withMarshaller((Marshaller)new DeleteFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteGameSessionQueueResponse deleteGameSessionQueue(DeleteGameSessionQueueRequest deleteGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGameSessionQueueRequest).withMarshaller((Marshaller)new DeleteGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteMatchmakingConfigurationResponse deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest deleteMatchmakingConfigurationRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMatchmakingConfigurationRequest).withMarshaller((Marshaller)new DeleteMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteScalingPolicyResponse deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScalingPolicyRequest).withMarshaller((Marshaller)new DeleteScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteVpcPeeringAuthorizationResponse deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest deleteVpcPeeringAuthorizationRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcPeeringAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteVpcPeeringAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcPeeringAuthorizationRequest).withMarshaller((Marshaller)new DeleteVpcPeeringAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcPeeringConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteVpcPeeringConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcPeeringConnectionRequest).withMarshaller((Marshaller)new DeleteVpcPeeringConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAliasResponse describeAlias(DescribeAliasRequest describeAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAliasRequest).withMarshaller((Marshaller)new DescribeAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBuildResponse describeBuild(DescribeBuildRequest describeBuildRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBuildRequest).withMarshaller((Marshaller)new DescribeBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEc2InstanceLimitsResponse describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest describeEc2InstanceLimitsRequest) throws InvalidRequestException, InternalServiceException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEc2InstanceLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEc2InstanceLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEc2InstanceLimitsRequest).withMarshaller((Marshaller)new DescribeEc2InstanceLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetAttributesResponse describeFleetAttributes(DescribeFleetAttributesRequest describeFleetAttributesRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetAttributesRequest).withMarshaller((Marshaller)new DescribeFleetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetCapacityResponse describeFleetCapacity(DescribeFleetCapacityRequest describeFleetCapacityRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetCapacityRequest).withMarshaller((Marshaller)new DescribeFleetCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetEventsResponse describeFleetEvents(DescribeFleetEventsRequest describeFleetEventsRequest) throws NotFoundException, InternalServiceException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetEventsRequest).withMarshaller((Marshaller)new DescribeFleetEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetPortSettingsResponse describeFleetPortSettings(DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetPortSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetPortSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetPortSettingsRequest).withMarshaller((Marshaller)new DescribeFleetPortSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetUtilizationResponse describeFleetUtilization(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetUtilizationRequest).withMarshaller((Marshaller)new DescribeFleetUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGameSessionDetailsResponse describeGameSessionDetails(DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGameSessionDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionDetailsRequest).withMarshaller((Marshaller)new DescribeGameSessionDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGameSessionPlacementResponse describeGameSessionPlacement(DescribeGameSessionPlacementRequest describeGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionPlacementRequest).withMarshaller((Marshaller)new DescribeGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGameSessionQueuesResponse describeGameSessionQueues(DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionQueuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGameSessionQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionQueuesRequest).withMarshaller((Marshaller)new DescribeGameSessionQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGameSessionsResponse describeGameSessions(DescribeGameSessionsRequest describeGameSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGameSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGameSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGameSessionsRequest).withMarshaller((Marshaller)new DescribeGameSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeInstancesResponse describeInstances(DescribeInstancesRequest describeInstancesRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstancesRequest).withMarshaller((Marshaller)new DescribeInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeMatchmakingResponse describeMatchmaking(DescribeMatchmakingRequest describeMatchmakingRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingRequest).withMarshaller((Marshaller)new DescribeMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeMatchmakingConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingConfigurationsRequest).withMarshaller((Marshaller)new DescribeMatchmakingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) throws InvalidRequestException, InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMatchmakingRuleSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeMatchmakingRuleSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMatchmakingRuleSetsRequest).withMarshaller((Marshaller)new DescribeMatchmakingRuleSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePlayerSessionsResponse describePlayerSessions(DescribePlayerSessionsRequest describePlayerSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePlayerSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePlayerSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePlayerSessionsRequest).withMarshaller((Marshaller)new DescribePlayerSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRuntimeConfigurationResponse describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuntimeConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRuntimeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuntimeConfigurationRequest).withMarshaller((Marshaller)new DescribeRuntimeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScalingPoliciesResponse describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeScalingPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingPoliciesRequest).withMarshaller((Marshaller)new DescribeScalingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest describeVpcPeeringAuthorizationsRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcPeeringAuthorizationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeVpcPeeringAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVpcPeeringAuthorizationsRequest).withMarshaller((Marshaller)new DescribeVpcPeeringAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcPeeringConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeVpcPeeringConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVpcPeeringConnectionsRequest).withMarshaller((Marshaller)new DescribeVpcPeeringConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetGameSessionLogUrlResponse getGameSessionLogUrl(GetGameSessionLogUrlRequest getGameSessionLogUrlRequest) throws InternalServiceException, NotFoundException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGameSessionLogUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetGameSessionLogUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGameSessionLogUrlRequest).withMarshaller((Marshaller)new GetGameSessionLogUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetInstanceAccessResponse getInstanceAccess(GetInstanceAccessRequest getInstanceAccessRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetInstanceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInstanceAccessRequest).withMarshaller((Marshaller)new GetInstanceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuildsRequest).withMarshaller((Marshaller)new ListBuildsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFleetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFleetsRequest).withMarshaller((Marshaller)new ListFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RequestUploadCredentialsResponse requestUploadCredentials(RequestUploadCredentialsRequest requestUploadCredentialsRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestUploadCredentialsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RequestUploadCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestUploadCredentialsRequest).withMarshaller((Marshaller)new RequestUploadCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ResolveAliasResponse resolveAlias(ResolveAliasRequest resolveAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, TerminalRoutingStrategyException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ResolveAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resolveAliasRequest).withMarshaller((Marshaller)new ResolveAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchGameSessionsResponse searchGameSessions(SearchGameSessionsRequest searchGameSessionsRequest) throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchGameSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchGameSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchGameSessionsRequest).withMarshaller((Marshaller)new SearchGameSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartFleetActionsResponse startFleetActions(StartFleetActionsRequest startFleetActionsRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFleetActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartFleetActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFleetActionsRequest).withMarshaller((Marshaller)new StartFleetActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartGameSessionPlacementResponse startGameSessionPlacement(StartGameSessionPlacementRequest startGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startGameSessionPlacementRequest).withMarshaller((Marshaller)new StartGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartMatchBackfillResponse startMatchBackfill(StartMatchBackfillRequest startMatchBackfillRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMatchBackfillResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartMatchBackfillResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMatchBackfillRequest).withMarshaller((Marshaller)new StartMatchBackfillRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartMatchmakingResponse startMatchmaking(StartMatchmakingRequest startMatchmakingRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMatchmakingRequest).withMarshaller((Marshaller)new StartMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopFleetActionsResponse stopFleetActions(StopFleetActionsRequest stopFleetActionsRequest) throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFleetActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopFleetActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopFleetActionsRequest).withMarshaller((Marshaller)new StopFleetActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopGameSessionPlacementResponse stopGameSessionPlacement(StopGameSessionPlacementRequest stopGameSessionPlacementRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopGameSessionPlacementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopGameSessionPlacementResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopGameSessionPlacementRequest).withMarshaller((Marshaller)new StopGameSessionPlacementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopMatchmakingResponse stopMatchmaking(StopMatchmakingRequest stopMatchmakingRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopMatchmakingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopMatchmakingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopMatchmakingRequest).withMarshaller((Marshaller)new StopMatchmakingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAliasRequest).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateBuildResponse updateBuild(UpdateBuildRequest updateBuildRequest) throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBuildResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBuildRequest).withMarshaller((Marshaller)new UpdateBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFleetAttributesResponse updateFleetAttributes(UpdateFleetAttributesRequest updateFleetAttributesRequest) throws NotFoundException, ConflictException, InvalidFleetStatusException, LimitExceededException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFleetAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetAttributesRequest).withMarshaller((Marshaller)new UpdateFleetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFleetCapacityResponse updateFleetCapacity(UpdateFleetCapacityRequest updateFleetCapacityRequest) throws NotFoundException, ConflictException, LimitExceededException, InvalidFleetStatusException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFleetCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetCapacityRequest).withMarshaller((Marshaller)new UpdateFleetCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFleetPortSettingsResponse updateFleetPortSettings(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) throws NotFoundException, ConflictException, InvalidFleetStatusException, LimitExceededException, InternalServiceException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetPortSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFleetPortSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetPortSettingsRequest).withMarshaller((Marshaller)new UpdateFleetPortSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateGameSessionResponse updateGameSession(UpdateGameSessionRequest updateGameSessionRequest) throws NotFoundException, ConflictException, InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateGameSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameSessionRequest).withMarshaller((Marshaller)new UpdateGameSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateGameSessionQueueResponse updateGameSessionQueue(UpdateGameSessionQueueRequest updateGameSessionQueueRequest) throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGameSessionQueueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateGameSessionQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGameSessionQueueRequest).withMarshaller((Marshaller)new UpdateGameSessionQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateMatchmakingConfigurationResponse updateMatchmakingConfiguration(UpdateMatchmakingConfigurationRequest updateMatchmakingConfigurationRequest) throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMatchmakingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateMatchmakingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMatchmakingConfigurationRequest).withMarshaller((Marshaller)new UpdateMatchmakingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRuntimeConfigurationResponse updateRuntimeConfiguration(UpdateRuntimeConfigurationRequest updateRuntimeConfigurationRequest) throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException, InvalidFleetStatusException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuntimeConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRuntimeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuntimeConfigurationRequest).withMarshaller((Marshaller)new UpdateRuntimeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ValidateMatchmakingRuleSetResponse validateMatchmakingRuleSet(ValidateMatchmakingRuleSetRequest validateMatchmakingRuleSetRequest) throws InternalServiceException, UnsupportedRegionException, InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateMatchmakingRuleSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ValidateMatchmakingRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateMatchmakingRuleSetRequest).withMarshaller((Marshaller)new ValidateMatchmakingRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GameLiftException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException").exceptionBuilderSupplier(FleetCapacityExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException").exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException").exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GameSessionFullException").exceptionBuilderSupplier(GameSessionFullException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").exceptionBuilderSupplier(UnsupportedRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").exceptionBuilderSupplier(InvalidFleetStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

