/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.SecurityStyle;
import software.amazon.awssdk.services.fsx.model.TieringPolicy;
import software.amazon.awssdk.services.fsx.model.UpdateSnaplockConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOntapVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JunctionPath").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::junctionPath)).setter(UpdateOntapVolumeConfiguration.setter(Builder::junctionPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()}).build();
    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityStyle").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::securityStyleAsString)).setter(UpdateOntapVolumeConfiguration.setter(Builder::securityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()}).build();
    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeInMegabytes").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::sizeInMegabytes)).setter(UpdateOntapVolumeConfiguration.setter(Builder::sizeInMegabytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()}).build();
    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEfficiencyEnabled").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::storageEfficiencyEnabled)).setter(UpdateOntapVolumeConfiguration.setter(Builder::storageEfficiencyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build()}).build();
    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TieringPolicy").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::tieringPolicy)).setter(UpdateOntapVolumeConfiguration.setter(Builder::tieringPolicy)).constructor(TieringPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()}).build();
    private static final SdkField<String> SNAPSHOT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotPolicy").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::snapshotPolicy)).setter(UpdateOntapVolumeConfiguration.setter(Builder::snapshotPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotPolicy").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::copyTagsToBackups)).setter(UpdateOntapVolumeConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<UpdateSnaplockConfiguration> SNAPLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnaplockConfiguration").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::snaplockConfiguration)).setter(UpdateOntapVolumeConfiguration.setter(Builder::snaplockConfiguration)).constructor(UpdateSnaplockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnaplockConfiguration").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeInBytes").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::sizeInBytes)).setter(UpdateOntapVolumeConfiguration.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD, SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, TIERING_POLICY_FIELD, SNAPSHOT_POLICY_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, SNAPLOCK_CONFIGURATION_FIELD, SIZE_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOntapVolumeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String junctionPath;
    private final String securityStyle;
    private final Integer sizeInMegabytes;
    private final Boolean storageEfficiencyEnabled;
    private final TieringPolicy tieringPolicy;
    private final String snapshotPolicy;
    private final Boolean copyTagsToBackups;
    private final UpdateSnaplockConfiguration snaplockConfiguration;
    private final Long sizeInBytes;

    private UpdateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.tieringPolicy = builder.tieringPolicy;
        this.snapshotPolicy = builder.snapshotPolicy;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.snaplockConfiguration = builder.snaplockConfiguration;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public final String junctionPath() {
        return this.junctionPath;
    }

    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(this.securityStyle);
    }

    public final String securityStyleAsString() {
        return this.securityStyle;
    }

    public final Integer sizeInMegabytes() {
        return this.sizeInMegabytes;
    }

    public final Boolean storageEfficiencyEnabled() {
        return this.storageEfficiencyEnabled;
    }

    public final TieringPolicy tieringPolicy() {
        return this.tieringPolicy;
    }

    public final String snapshotPolicy() {
        return this.snapshotPolicy;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final UpdateSnaplockConfiguration snaplockConfiguration() {
        return this.snaplockConfiguration;
    }

    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.snaplockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOntapVolumeConfiguration)) {
            return false;
        }
        UpdateOntapVolumeConfiguration other = (UpdateOntapVolumeConfiguration)obj;
        return Objects.equals(this.junctionPath(), other.junctionPath()) && Objects.equals(this.securityStyleAsString(), other.securityStyleAsString()) && Objects.equals(this.sizeInMegabytes(), other.sizeInMegabytes()) && Objects.equals(this.storageEfficiencyEnabled(), other.storageEfficiencyEnabled()) && Objects.equals(this.tieringPolicy(), other.tieringPolicy()) && Objects.equals(this.snapshotPolicy(), other.snapshotPolicy()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.snaplockConfiguration(), other.snaplockConfiguration()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOntapVolumeConfiguration").add("JunctionPath", (Object)this.junctionPath()).add("SecurityStyle", (Object)this.securityStyleAsString()).add("SizeInMegabytes", (Object)this.sizeInMegabytes()).add("StorageEfficiencyEnabled", (Object)this.storageEfficiencyEnabled()).add("TieringPolicy", (Object)this.tieringPolicy()).add("SnapshotPolicy", (Object)this.snapshotPolicy()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("SnaplockConfiguration", (Object)this.snaplockConfiguration()).add("SizeInBytes", (Object)this.sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JunctionPath": {
                return Optional.ofNullable(clazz.cast(this.junctionPath()));
            }
            case "SecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.securityStyleAsString()));
            }
            case "SizeInMegabytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInMegabytes()));
            }
            case "StorageEfficiencyEnabled": {
                return Optional.ofNullable(clazz.cast(this.storageEfficiencyEnabled()));
            }
            case "TieringPolicy": {
                return Optional.ofNullable(clazz.cast(this.tieringPolicy()));
            }
            case "SnapshotPolicy": {
                return Optional.ofNullable(clazz.cast(this.snapshotPolicy()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "SnaplockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snaplockConfiguration()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JunctionPath", JUNCTION_PATH_FIELD);
        map.put("SecurityStyle", SECURITY_STYLE_FIELD);
        map.put("SizeInMegabytes", SIZE_IN_MEGABYTES_FIELD);
        map.put("StorageEfficiencyEnabled", STORAGE_EFFICIENCY_ENABLED_FIELD);
        map.put("TieringPolicy", TIERING_POLICY_FIELD);
        map.put("SnapshotPolicy", SNAPSHOT_POLICY_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("SnaplockConfiguration", SNAPLOCK_CONFIGURATION_FIELD);
        map.put("SizeInBytes", SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((UpdateOntapVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String junctionPath;
        private String securityStyle;
        private Integer sizeInMegabytes;
        private Boolean storageEfficiencyEnabled;
        private TieringPolicy tieringPolicy;
        private String snapshotPolicy;
        private Boolean copyTagsToBackups;
        private UpdateSnaplockConfiguration snaplockConfiguration;
        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOntapVolumeConfiguration model) {
            this.junctionPath(model.junctionPath);
            this.securityStyle(model.securityStyle);
            this.sizeInMegabytes(model.sizeInMegabytes);
            this.storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            this.tieringPolicy(model.tieringPolicy);
            this.snapshotPolicy(model.snapshotPolicy);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.snaplockConfiguration(model.snaplockConfiguration);
            this.sizeInBytes(model.sizeInBytes);
        }

        public final String getJunctionPath() {
            return this.junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return this.securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return this.sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return this.storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return this.tieringPolicy != null ? this.tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getSnapshotPolicy() {
            return this.snapshotPolicy;
        }

        public final void setSnapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
        }

        @Override
        public final Builder snapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final UpdateSnaplockConfiguration.Builder getSnaplockConfiguration() {
            return this.snaplockConfiguration != null ? this.snaplockConfiguration.toBuilder() : null;
        }

        public final void setSnaplockConfiguration(UpdateSnaplockConfiguration.BuilderImpl snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration != null ? snaplockConfiguration.build() : null;
        }

        @Override
        public final Builder snaplockConfiguration(UpdateSnaplockConfiguration snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration;
            return this;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public UpdateOntapVolumeConfiguration build() {
            return new UpdateOntapVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateOntapVolumeConfiguration> {
        public Builder junctionPath(String var1);

        public Builder securityStyle(String var1);

        public Builder securityStyle(SecurityStyle var1);

        public Builder sizeInMegabytes(Integer var1);

        public Builder storageEfficiencyEnabled(Boolean var1);

        public Builder tieringPolicy(TieringPolicy var1);

        default public Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return this.tieringPolicy((TieringPolicy)((TieringPolicy.Builder)TieringPolicy.builder().applyMutation(tieringPolicy)).build());
        }

        public Builder snapshotPolicy(String var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder snaplockConfiguration(UpdateSnaplockConfiguration var1);

        default public Builder snaplockConfiguration(Consumer<UpdateSnaplockConfiguration.Builder> snaplockConfiguration) {
            return this.snaplockConfiguration((UpdateSnaplockConfiguration)((UpdateSnaplockConfiguration.Builder)UpdateSnaplockConfiguration.builder().applyMutation(snaplockConfiguration)).build());
        }

        public Builder sizeInBytes(Long var1);
    }
}

