/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFiltersCopier;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageVirtualMachinesRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, DescribeStorageVirtualMachinesRequest> {
    private static final SdkField<List<String>> STORAGE_VIRTUAL_MACHINE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageVirtualMachineIds").getter(DescribeStorageVirtualMachinesRequest.getter(DescribeStorageVirtualMachinesRequest::storageVirtualMachineIds)).setter(DescribeStorageVirtualMachinesRequest.setter(Builder::storageVirtualMachineIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StorageVirtualMachineFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeStorageVirtualMachinesRequest.getter(DescribeStorageVirtualMachinesRequest::filters)).setter(DescribeStorageVirtualMachinesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageVirtualMachineFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeStorageVirtualMachinesRequest.getter(DescribeStorageVirtualMachinesRequest::maxResults)).setter(DescribeStorageVirtualMachinesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStorageVirtualMachinesRequest.getter(DescribeStorageVirtualMachinesRequest::nextToken)).setter(DescribeStorageVirtualMachinesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_VIRTUAL_MACHINE_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageVirtualMachinesRequest.memberNameToFieldInitializer();
    private final List<String> storageVirtualMachineIds;
    private final List<StorageVirtualMachineFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeStorageVirtualMachinesRequest(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachineIds = builder.storageVirtualMachineIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageVirtualMachineIds() {
        return this.storageVirtualMachineIds != null && !(this.storageVirtualMachineIds instanceof SdkAutoConstructList);
    }

    public final List<String> storageVirtualMachineIds() {
        return this.storageVirtualMachineIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<StorageVirtualMachineFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageVirtualMachineIds() ? this.storageVirtualMachineIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageVirtualMachinesRequest)) {
            return false;
        }
        DescribeStorageVirtualMachinesRequest other = (DescribeStorageVirtualMachinesRequest)((Object)obj);
        return this.hasStorageVirtualMachineIds() == other.hasStorageVirtualMachineIds() && Objects.equals(this.storageVirtualMachineIds(), other.storageVirtualMachineIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageVirtualMachinesRequest").add("StorageVirtualMachineIds", this.hasStorageVirtualMachineIds() ? this.storageVirtualMachineIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageVirtualMachineIds": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageVirtualMachineIds", STORAGE_VIRTUAL_MACHINE_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageVirtualMachinesRequest, T> g) {
        return obj -> g.apply((DescribeStorageVirtualMachinesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private List<String> storageVirtualMachineIds = DefaultSdkAutoConstructList.getInstance();
        private List<StorageVirtualMachineFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageVirtualMachinesRequest model) {
            super(model);
            this.storageVirtualMachineIds(model.storageVirtualMachineIds);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getStorageVirtualMachineIds() {
            if (this.storageVirtualMachineIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storageVirtualMachineIds;
        }

        public final void setStorageVirtualMachineIds(Collection<String> storageVirtualMachineIds) {
            this.storageVirtualMachineIds = StorageVirtualMachineIdsCopier.copy(storageVirtualMachineIds);
        }

        @Override
        public final Builder storageVirtualMachineIds(Collection<String> storageVirtualMachineIds) {
            this.storageVirtualMachineIds = StorageVirtualMachineIdsCopier.copy(storageVirtualMachineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageVirtualMachineIds(String ... storageVirtualMachineIds) {
            this.storageVirtualMachineIds(Arrays.asList(storageVirtualMachineIds));
            return this;
        }

        public final List<StorageVirtualMachineFilter.Builder> getFilters() {
            List<StorageVirtualMachineFilter.Builder> result = StorageVirtualMachineFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<StorageVirtualMachineFilter.BuilderImpl> filters) {
            this.filters = StorageVirtualMachineFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<StorageVirtualMachineFilter> filters) {
            this.filters = StorageVirtualMachineFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(StorageVirtualMachineFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<StorageVirtualMachineFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (StorageVirtualMachineFilter)((StorageVirtualMachineFilter.Builder)StorageVirtualMachineFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorageVirtualMachinesRequest build() {
            return new DescribeStorageVirtualMachinesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageVirtualMachinesRequest> {
        public Builder storageVirtualMachineIds(Collection<String> var1);

        public Builder storageVirtualMachineIds(String ... var1);

        public Builder filters(Collection<StorageVirtualMachineFilter> var1);

        public Builder filters(StorageVirtualMachineFilter ... var1);

        public Builder filters(Consumer<StorageVirtualMachineFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

