/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;

public class DescribeFileSystemsIterable
implements SdkIterable<DescribeFileSystemsResponse> {
    private final FSxClient client;
    private final DescribeFileSystemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFileSystemsIterable(FSxClient client, DescribeFileSystemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFileSystemsResponseFetcher();
    }

    public Iterator<DescribeFileSystemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeFileSystemsResponseFetcher
    implements SyncPageFetcher<DescribeFileSystemsResponse> {
        private DescribeFileSystemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileSystemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFileSystemsResponse nextPage(DescribeFileSystemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileSystemsIterable.this.client.describeFileSystems(DescribeFileSystemsIterable.this.firstRequest);
            }
            return DescribeFileSystemsIterable.this.client.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

