/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy;
import software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeOption;
import software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotAndUpdateVolumeRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CopySnapshotAndUpdateVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CopySnapshotAndUpdateVolumeRequest.getter(CopySnapshotAndUpdateVolumeRequest::clientRequestToken)).setter(CopySnapshotAndUpdateVolumeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(CopySnapshotAndUpdateVolumeRequest.getter(CopySnapshotAndUpdateVolumeRequest::volumeId)).setter(CopySnapshotAndUpdateVolumeRequest.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> SOURCE_SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSnapshotARN").getter(CopySnapshotAndUpdateVolumeRequest.getter(CopySnapshotAndUpdateVolumeRequest::sourceSnapshotARN)).setter(CopySnapshotAndUpdateVolumeRequest.setter(Builder::sourceSnapshotARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotARN").build()}).build();
    private static final SdkField<String> COPY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyStrategy").getter(CopySnapshotAndUpdateVolumeRequest.getter(CopySnapshotAndUpdateVolumeRequest::copyStrategyAsString)).setter(CopySnapshotAndUpdateVolumeRequest.setter(Builder::copyStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStrategy").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(CopySnapshotAndUpdateVolumeRequest.getter(CopySnapshotAndUpdateVolumeRequest::optionsAsStrings)).setter(CopySnapshotAndUpdateVolumeRequest.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, VOLUME_ID_FIELD, SOURCE_SNAPSHOT_ARN_FIELD, COPY_STRATEGY_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopySnapshotAndUpdateVolumeRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String volumeId;
    private final String sourceSnapshotARN;
    private final String copyStrategy;
    private final List<String> options;

    private CopySnapshotAndUpdateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.sourceSnapshotARN = builder.sourceSnapshotARN;
        this.copyStrategy = builder.copyStrategy;
        this.options = builder.options;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final String sourceSnapshotARN() {
        return this.sourceSnapshotARN;
    }

    public final OpenZFSCopyStrategy copyStrategy() {
        return OpenZFSCopyStrategy.fromValue(this.copyStrategy);
    }

    public final String copyStrategyAsString() {
        return this.copyStrategy;
    }

    public final List<UpdateOpenZFSVolumeOption> options() {
        return UpdateOpenZFSVolumeOptionsCopier.copyStringToEnum(this.options);
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> optionsAsStrings() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.optionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotAndUpdateVolumeRequest)) {
            return false;
        }
        CopySnapshotAndUpdateVolumeRequest other = (CopySnapshotAndUpdateVolumeRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.sourceSnapshotARN(), other.sourceSnapshotARN()) && Objects.equals(this.copyStrategyAsString(), other.copyStrategyAsString()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.optionsAsStrings(), other.optionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CopySnapshotAndUpdateVolumeRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("VolumeId", (Object)this.volumeId()).add("SourceSnapshotARN", (Object)this.sourceSnapshotARN()).add("CopyStrategy", (Object)this.copyStrategyAsString()).add("Options", this.hasOptions() ? this.optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "SourceSnapshotARN": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotARN()));
            }
            case "CopyStrategy": {
                return Optional.ofNullable(clazz.cast(this.copyStrategyAsString()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("SourceSnapshotARN", SOURCE_SNAPSHOT_ARN_FIELD);
        map.put("CopyStrategy", COPY_STRATEGY_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotAndUpdateVolumeRequest, T> g) {
        return obj -> g.apply((CopySnapshotAndUpdateVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String volumeId;
        private String sourceSnapshotARN;
        private String copyStrategy;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotAndUpdateVolumeRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.volumeId(model.volumeId);
            this.sourceSnapshotARN(model.sourceSnapshotARN);
            this.copyStrategy(model.copyStrategy);
            this.optionsWithStrings(model.options);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getSourceSnapshotARN() {
            return this.sourceSnapshotARN;
        }

        public final void setSourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
        }

        @Override
        public final Builder sourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
            return this;
        }

        public final String getCopyStrategy() {
            return this.copyStrategy;
        }

        public final void setCopyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
        }

        @Override
        public final Builder copyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
            return this;
        }

        @Override
        public final Builder copyStrategy(OpenZFSCopyStrategy copyStrategy) {
            this.copyStrategy(copyStrategy == null ? null : copyStrategy.toString());
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String ... options) {
            this.optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<UpdateOpenZFSVolumeOption> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(UpdateOpenZFSVolumeOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotAndUpdateVolumeRequest build() {
            return new CopySnapshotAndUpdateVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopySnapshotAndUpdateVolumeRequest> {
        public Builder clientRequestToken(String var1);

        public Builder volumeId(String var1);

        public Builder sourceSnapshotARN(String var1);

        public Builder copyStrategy(String var1);

        public Builder copyStrategy(OpenZFSCopyStrategy var1);

        public Builder optionsWithStrings(Collection<String> var1);

        public Builder optionsWithStrings(String ... var1);

        public Builder options(Collection<UpdateOpenZFSVolumeOption> var1);

        public Builder options(UpdateOpenZFSVolumeOption ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

