/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;

public class DescribeFileSystemsPublisher
implements SdkPublisher<DescribeFileSystemsResponse> {
    private final FSxAsyncClient client;
    private final DescribeFileSystemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFileSystemsPublisher(FSxAsyncClient client, DescribeFileSystemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFileSystemsPublisher(FSxAsyncClient client, DescribeFileSystemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFileSystemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFileSystemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFileSystemsResponseFetcher
    implements AsyncPageFetcher<DescribeFileSystemsResponse> {
        private DescribeFileSystemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileSystemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFileSystemsResponse> nextPage(DescribeFileSystemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileSystemsPublisher.this.client.describeFileSystems(DescribeFileSystemsPublisher.this.firstRequest);
            }
            return DescribeFileSystemsPublisher.this.client.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

