/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;

public class DescribeBackupsPublisher
implements SdkPublisher<DescribeBackupsResponse> {
    private final FSxAsyncClient client;
    private final DescribeBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBackupsPublisher(FSxAsyncClient client, DescribeBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBackupsPublisher(FSxAsyncClient client, DescribeBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeBackupsResponseFetcher
    implements AsyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBackupsResponse> nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsPublisher.this.client.describeBackups(DescribeBackupsPublisher.this.firstRequest);
            }
            return DescribeBackupsPublisher.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

