/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveDirectoryBackupAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveDirectoryBackupAttributes> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ActiveDirectoryBackupAttributes.getter(ActiveDirectoryBackupAttributes::domainName)).setter(ActiveDirectoryBackupAttributes.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryId").getter(ActiveDirectoryBackupAttributes.getter(ActiveDirectoryBackupAttributes::activeDirectoryId)).setter(ActiveDirectoryBackupAttributes.setter(Builder::activeDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(ActiveDirectoryBackupAttributes.getter(ActiveDirectoryBackupAttributes::resourceARN)).setter(ActiveDirectoryBackupAttributes.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ACTIVE_DIRECTORY_ID_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActiveDirectoryBackupAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String activeDirectoryId;
    private final String resourceARN;

    private ActiveDirectoryBackupAttributes(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.activeDirectoryId = builder.activeDirectoryId;
        this.resourceARN = builder.resourceARN;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryBackupAttributes)) {
            return false;
        }
        ActiveDirectoryBackupAttributes other = (ActiveDirectoryBackupAttributes)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeDirectoryId(), other.activeDirectoryId()) && Objects.equals(this.resourceARN(), other.resourceARN());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveDirectoryBackupAttributes").add("DomainName", (Object)this.domainName()).add("ActiveDirectoryId", (Object)this.activeDirectoryId()).add("ResourceARN", (Object)this.resourceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActiveDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryId()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveDirectoryId", ACTIVE_DIRECTORY_ID_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryBackupAttributes, T> g) {
        return obj -> g.apply((ActiveDirectoryBackupAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String activeDirectoryId;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryBackupAttributes model) {
            this.domainName(model.domainName);
            this.activeDirectoryId(model.activeDirectoryId);
            this.resourceARN(model.resourceARN);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActiveDirectoryId() {
            return this.activeDirectoryId;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public ActiveDirectoryBackupAttributes build() {
            return new ActiveDirectoryBackupAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveDirectoryBackupAttributes> {
        public Builder domainName(String var1);

        public Builder activeDirectoryId(String var1);

        public Builder resourceARN(String var1);
    }
}

