/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse;

public class DescribeFileCachesIterable
implements SdkIterable<DescribeFileCachesResponse> {
    private final FSxClient client;
    private final DescribeFileCachesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFileCachesIterable(FSxClient client, DescribeFileCachesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFileCachesResponseFetcher();
    }

    public Iterator<DescribeFileCachesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeFileCachesResponseFetcher
    implements SyncPageFetcher<DescribeFileCachesResponse> {
        private DescribeFileCachesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFileCachesResponse nextPage(DescribeFileCachesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileCachesIterable.this.client.describeFileCaches(DescribeFileCachesIterable.this.firstRequest);
            }
            return DescribeFileCachesIterable.this.client.describeFileCaches((DescribeFileCachesRequest)((Object)DescribeFileCachesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

