/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AggregatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateConfiguration> {
    private static final SdkField<List<String>> AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregates").getter(AggregateConfiguration.getter(AggregateConfiguration::aggregates)).setter(AggregateConfiguration.setter(Builder::aggregates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_CONSTITUENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalConstituents").getter(AggregateConfiguration.getter(AggregateConfiguration::totalConstituents)).setter(AggregateConfiguration.setter(Builder::totalConstituents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalConstituents").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATES_FIELD, TOTAL_CONSTITUENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Aggregates", AGGREGATES_FIELD);
            this.put("TotalConstituents", TOTAL_CONSTITUENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> aggregates;
    private final Integer totalConstituents;

    private AggregateConfiguration(BuilderImpl builder) {
        this.aggregates = builder.aggregates;
        this.totalConstituents = builder.totalConstituents;
    }

    public final boolean hasAggregates() {
        return this.aggregates != null && !(this.aggregates instanceof SdkAutoConstructList);
    }

    public final List<String> aggregates() {
        return this.aggregates;
    }

    public final Integer totalConstituents() {
        return this.totalConstituents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregates() ? this.aggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalConstituents());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConfiguration)) {
            return false;
        }
        AggregateConfiguration other = (AggregateConfiguration)obj;
        return this.hasAggregates() == other.hasAggregates() && Objects.equals(this.aggregates(), other.aggregates()) && Objects.equals(this.totalConstituents(), other.totalConstituents());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateConfiguration").add("Aggregates", this.hasAggregates() ? this.aggregates() : null).add("TotalConstituents", (Object)this.totalConstituents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Aggregates": {
                return Optional.ofNullable(clazz.cast(this.aggregates()));
            }
            case "TotalConstituents": {
                return Optional.ofNullable(clazz.cast(this.totalConstituents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AggregateConfiguration, T> g) {
        return obj -> g.apply((AggregateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> aggregates = DefaultSdkAutoConstructList.getInstance();
        private Integer totalConstituents;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConfiguration model) {
            this.aggregates(model.aggregates);
            this.totalConstituents(model.totalConstituents);
        }

        public final Collection<String> getAggregates() {
            if (this.aggregates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregates;
        }

        public final void setAggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
        }

        @Override
        public final Builder aggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregates(String ... aggregates) {
            this.aggregates(Arrays.asList(aggregates));
            return this;
        }

        public final Integer getTotalConstituents() {
            return this.totalConstituents;
        }

        public final void setTotalConstituents(Integer totalConstituents) {
            this.totalConstituents = totalConstituents;
        }

        @Override
        public final Builder totalConstituents(Integer totalConstituents) {
            this.totalConstituents = totalConstituents;
            return this;
        }

        public AggregateConfiguration build() {
            return new AggregateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateConfiguration> {
        public Builder aggregates(Collection<String> var1);

        public Builder aggregates(String ... var1);

        public Builder totalConstituents(Integer var1);
    }
}

