/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DeleteOpenZFSVolumeOption;
import software.amazon.awssdk.services.fsx.model.DeleteOpenZFSVolumeOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVolumeOpenZFSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteVolumeOpenZFSConfiguration> {
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(DeleteVolumeOpenZFSConfiguration.getter(DeleteVolumeOpenZFSConfiguration::optionsAsStrings)).setter(DeleteVolumeOpenZFSConfiguration.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> options;

    private DeleteVolumeOpenZFSConfiguration(BuilderImpl builder) {
        this.options = builder.options;
    }

    public final List<DeleteOpenZFSVolumeOption> options() {
        return DeleteOpenZFSVolumeOptionsCopier.copyStringToEnum(this.options);
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> optionsAsStrings() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.optionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeOpenZFSConfiguration)) {
            return false;
        }
        DeleteVolumeOpenZFSConfiguration other = (DeleteVolumeOpenZFSConfiguration)obj;
        return this.hasOptions() == other.hasOptions() && Objects.equals(this.optionsAsStrings(), other.optionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVolumeOpenZFSConfiguration").add("Options", this.hasOptions() ? this.optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeOpenZFSConfiguration, T> g) {
        return obj -> g.apply((DeleteVolumeOpenZFSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeOpenZFSConfiguration model) {
            this.optionsWithStrings(model.options);
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = DeleteOpenZFSVolumeOptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = DeleteOpenZFSVolumeOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String ... options) {
            this.optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<DeleteOpenZFSVolumeOption> options) {
            this.options = DeleteOpenZFSVolumeOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(DeleteOpenZFSVolumeOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public DeleteVolumeOpenZFSConfiguration build() {
            return new DeleteVolumeOpenZFSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteVolumeOpenZFSConfiguration> {
        public Builder optionsWithStrings(Collection<String> var1);

        public Builder optionsWithStrings(String ... var1);

        public Builder options(Collection<DeleteOpenZFSVolumeOption> var1);

        public Builder options(DeleteOpenZFSVolumeOption ... var1);
    }
}

