/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileCacheType {
    LUSTRE("LUSTRE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileCacheType> VALUE_MAP;
    private final String value;

    private FileCacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileCacheType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileCacheType> knownValues() {
        EnumSet<FileCacheType> knownValues = EnumSet.allOf(FileCacheType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileCacheType.class, FileCacheType::toString);
    }
}

