/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AggregatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAggregateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateAggregateConfiguration> {
    private static final SdkField<List<String>> AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregates").getter(CreateAggregateConfiguration.getter(CreateAggregateConfiguration::aggregates)).setter(CreateAggregateConfiguration.setter(Builder::aggregates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONSTITUENTS_PER_AGGREGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConstituentsPerAggregate").getter(CreateAggregateConfiguration.getter(CreateAggregateConfiguration::constituentsPerAggregate)).setter(CreateAggregateConfiguration.setter(Builder::constituentsPerAggregate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstituentsPerAggregate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATES_FIELD, CONSTITUENTS_PER_AGGREGATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> aggregates;
    private final Integer constituentsPerAggregate;

    private CreateAggregateConfiguration(BuilderImpl builder) {
        this.aggregates = builder.aggregates;
        this.constituentsPerAggregate = builder.constituentsPerAggregate;
    }

    public final boolean hasAggregates() {
        return this.aggregates != null && !(this.aggregates instanceof SdkAutoConstructList);
    }

    public final List<String> aggregates() {
        return this.aggregates;
    }

    public final Integer constituentsPerAggregate() {
        return this.constituentsPerAggregate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregates() ? this.aggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.constituentsPerAggregate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregateConfiguration)) {
            return false;
        }
        CreateAggregateConfiguration other = (CreateAggregateConfiguration)obj;
        return this.hasAggregates() == other.hasAggregates() && Objects.equals(this.aggregates(), other.aggregates()) && Objects.equals(this.constituentsPerAggregate(), other.constituentsPerAggregate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAggregateConfiguration").add("Aggregates", this.hasAggregates() ? this.aggregates() : null).add("ConstituentsPerAggregate", (Object)this.constituentsPerAggregate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Aggregates": {
                return Optional.ofNullable(clazz.cast(this.aggregates()));
            }
            case "ConstituentsPerAggregate": {
                return Optional.ofNullable(clazz.cast(this.constituentsPerAggregate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAggregateConfiguration, T> g) {
        return obj -> g.apply((CreateAggregateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> aggregates = DefaultSdkAutoConstructList.getInstance();
        private Integer constituentsPerAggregate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAggregateConfiguration model) {
            this.aggregates(model.aggregates);
            this.constituentsPerAggregate(model.constituentsPerAggregate);
        }

        public final Collection<String> getAggregates() {
            if (this.aggregates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregates;
        }

        public final void setAggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
        }

        @Override
        public final Builder aggregates(Collection<String> aggregates) {
            this.aggregates = AggregatesCopier.copy(aggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregates(String ... aggregates) {
            this.aggregates(Arrays.asList(aggregates));
            return this;
        }

        public final Integer getConstituentsPerAggregate() {
            return this.constituentsPerAggregate;
        }

        public final void setConstituentsPerAggregate(Integer constituentsPerAggregate) {
            this.constituentsPerAggregate = constituentsPerAggregate;
        }

        @Override
        public final Builder constituentsPerAggregate(Integer constituentsPerAggregate) {
            this.constituentsPerAggregate = constituentsPerAggregate;
            return this;
        }

        public CreateAggregateConfiguration build() {
            return new CreateAggregateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateAggregateConfiguration> {
        public Builder aggregates(Collection<String> var1);

        public Builder aggregates(String ... var1);

        public Builder constituentsPerAggregate(Integer var1);
    }
}

