/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration;
import software.amazon.awssdk.services.fsx.model.SubDirectoriesPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileCacheDataRepositoryAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileCacheDataRepositoryAssociation> {
    private static final SdkField<String> FILE_CACHE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCachePath").getter(FileCacheDataRepositoryAssociation.getter(FileCacheDataRepositoryAssociation::fileCachePath)).setter(FileCacheDataRepositoryAssociation.setter(Builder::fileCachePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCachePath").build()}).build();
    private static final SdkField<String> DATA_REPOSITORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRepositoryPath").getter(FileCacheDataRepositoryAssociation.getter(FileCacheDataRepositoryAssociation::dataRepositoryPath)).setter(FileCacheDataRepositoryAssociation.setter(Builder::dataRepositoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryPath").build()}).build();
    private static final SdkField<List<String>> DATA_REPOSITORY_SUBDIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataRepositorySubdirectories").getter(FileCacheDataRepositoryAssociation.getter(FileCacheDataRepositoryAssociation::dataRepositorySubdirectories)).setter(FileCacheDataRepositoryAssociation.setter(Builder::dataRepositorySubdirectories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositorySubdirectories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FileCacheNFSConfiguration> NFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFS").getter(FileCacheDataRepositoryAssociation.getter(FileCacheDataRepositoryAssociation::nfs)).setter(FileCacheDataRepositoryAssociation.setter(Builder::nfs)).constructor(FileCacheNFSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CACHE_PATH_FIELD, DATA_REPOSITORY_PATH_FIELD, DATA_REPOSITORY_SUBDIRECTORIES_FIELD, NFS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileCachePath;
    private final String dataRepositoryPath;
    private final List<String> dataRepositorySubdirectories;
    private final FileCacheNFSConfiguration nfs;

    private FileCacheDataRepositoryAssociation(BuilderImpl builder) {
        this.fileCachePath = builder.fileCachePath;
        this.dataRepositoryPath = builder.dataRepositoryPath;
        this.dataRepositorySubdirectories = builder.dataRepositorySubdirectories;
        this.nfs = builder.nfs;
    }

    public final String fileCachePath() {
        return this.fileCachePath;
    }

    public final String dataRepositoryPath() {
        return this.dataRepositoryPath;
    }

    public final boolean hasDataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories != null && !(this.dataRepositorySubdirectories instanceof SdkAutoConstructList);
    }

    public final List<String> dataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories;
    }

    public final FileCacheNFSConfiguration nfs() {
        return this.nfs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCachePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRepositoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataRepositorySubdirectories() ? this.dataRepositorySubdirectories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nfs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheDataRepositoryAssociation)) {
            return false;
        }
        FileCacheDataRepositoryAssociation other = (FileCacheDataRepositoryAssociation)obj;
        return Objects.equals(this.fileCachePath(), other.fileCachePath()) && Objects.equals(this.dataRepositoryPath(), other.dataRepositoryPath()) && this.hasDataRepositorySubdirectories() == other.hasDataRepositorySubdirectories() && Objects.equals(this.dataRepositorySubdirectories(), other.dataRepositorySubdirectories()) && Objects.equals(this.nfs(), other.nfs());
    }

    public final String toString() {
        return ToString.builder((String)"FileCacheDataRepositoryAssociation").add("FileCachePath", (Object)this.fileCachePath()).add("DataRepositoryPath", (Object)this.dataRepositoryPath()).add("DataRepositorySubdirectories", this.hasDataRepositorySubdirectories() ? this.dataRepositorySubdirectories() : null).add("NFS", (Object)this.nfs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCachePath": {
                return Optional.ofNullable(clazz.cast(this.fileCachePath()));
            }
            case "DataRepositoryPath": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryPath()));
            }
            case "DataRepositorySubdirectories": {
                return Optional.ofNullable(clazz.cast(this.dataRepositorySubdirectories()));
            }
            case "NFS": {
                return Optional.ofNullable(clazz.cast(this.nfs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileCacheDataRepositoryAssociation, T> g) {
        return obj -> g.apply((FileCacheDataRepositoryAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileCachePath;
        private String dataRepositoryPath;
        private List<String> dataRepositorySubdirectories = DefaultSdkAutoConstructList.getInstance();
        private FileCacheNFSConfiguration nfs;

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheDataRepositoryAssociation model) {
            this.fileCachePath(model.fileCachePath);
            this.dataRepositoryPath(model.dataRepositoryPath);
            this.dataRepositorySubdirectories(model.dataRepositorySubdirectories);
            this.nfs(model.nfs);
        }

        public final String getFileCachePath() {
            return this.fileCachePath;
        }

        public final void setFileCachePath(String fileCachePath) {
            this.fileCachePath = fileCachePath;
        }

        @Override
        public final Builder fileCachePath(String fileCachePath) {
            this.fileCachePath = fileCachePath;
            return this;
        }

        public final String getDataRepositoryPath() {
            return this.dataRepositoryPath;
        }

        public final void setDataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
        }

        @Override
        public final Builder dataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        public final Collection<String> getDataRepositorySubdirectories() {
            if (this.dataRepositorySubdirectories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataRepositorySubdirectories;
        }

        public final void setDataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories = SubDirectoriesPathsCopier.copy(dataRepositorySubdirectories);
        }

        @Override
        public final Builder dataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories = SubDirectoriesPathsCopier.copy(dataRepositorySubdirectories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositorySubdirectories(String ... dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories(Arrays.asList(dataRepositorySubdirectories));
            return this;
        }

        public final FileCacheNFSConfiguration.Builder getNfs() {
            return this.nfs != null ? this.nfs.toBuilder() : null;
        }

        public final void setNfs(FileCacheNFSConfiguration.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(FileCacheNFSConfiguration nfs) {
            this.nfs = nfs;
            return this;
        }

        public FileCacheDataRepositoryAssociation build() {
            return new FileCacheDataRepositoryAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileCacheDataRepositoryAssociation> {
        public Builder fileCachePath(String var1);

        public Builder dataRepositoryPath(String var1);

        public Builder dataRepositorySubdirectories(Collection<String> var1);

        public Builder dataRepositorySubdirectories(String ... var1);

        public Builder nfs(FileCacheNFSConfiguration var1);

        default public Builder nfs(Consumer<FileCacheNFSConfiguration.Builder> nfs) {
            return this.nfs((FileCacheNFSConfiguration)((FileCacheNFSConfiguration.Builder)FileCacheNFSConfiguration.builder().applyMutation(nfs)).build());
        }
    }
}

