/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachine;

public class DescribeStorageVirtualMachinesPublisher
implements SdkPublisher<DescribeStorageVirtualMachinesResponse> {
    private final FSxAsyncClient client;
    private final DescribeStorageVirtualMachinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStorageVirtualMachinesPublisher(FSxAsyncClient client, DescribeStorageVirtualMachinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStorageVirtualMachinesPublisher(FSxAsyncClient client, DescribeStorageVirtualMachinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStorageVirtualMachinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStorageVirtualMachinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StorageVirtualMachine> storageVirtualMachines() {
        Function<DescribeStorageVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageVirtualMachines() != null) {
                return response.storageVirtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStorageVirtualMachinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStorageVirtualMachinesResponseFetcher
    implements AsyncPageFetcher<DescribeStorageVirtualMachinesResponse> {
        private DescribeStorageVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStorageVirtualMachinesResponse> nextPage(DescribeStorageVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageVirtualMachinesPublisher.this.client.describeStorageVirtualMachines(DescribeStorageVirtualMachinesPublisher.this.firstRequest);
            }
            return DescribeStorageVirtualMachinesPublisher.this.client.describeStorageVirtualMachines((DescribeStorageVirtualMachinesRequest)((Object)DescribeStorageVirtualMachinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

