/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataCompressionType {
    NONE("NONE"),
    LZ4("LZ4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataCompressionType> VALUE_MAP;
    private final String value;

    private DataCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCompressionType> knownValues() {
        EnumSet<DataCompressionType> knownValues = EnumSet.allOf(DataCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataCompressionType.class, DataCompressionType::toString);
    }
}

