/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdministrativeActionType {
    FILE_SYSTEM_UPDATE("FILE_SYSTEM_UPDATE"),
    STORAGE_OPTIMIZATION("STORAGE_OPTIMIZATION"),
    FILE_SYSTEM_ALIAS_ASSOCIATION("FILE_SYSTEM_ALIAS_ASSOCIATION"),
    FILE_SYSTEM_ALIAS_DISASSOCIATION("FILE_SYSTEM_ALIAS_DISASSOCIATION"),
    VOLUME_UPDATE("VOLUME_UPDATE"),
    SNAPSHOT_UPDATE("SNAPSHOT_UPDATE"),
    RELEASE_NFS_V3_LOCKS("RELEASE_NFS_V3_LOCKS"),
    VOLUME_RESTORE("VOLUME_RESTORE"),
    THROUGHPUT_OPTIMIZATION("THROUGHPUT_OPTIMIZATION"),
    IOPS_OPTIMIZATION("IOPS_OPTIMIZATION"),
    STORAGE_TYPE_OPTIMIZATION("STORAGE_TYPE_OPTIMIZATION"),
    MISCONFIGURED_STATE_RECOVERY("MISCONFIGURED_STATE_RECOVERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdministrativeActionType> VALUE_MAP;
    private final String value;

    private AdministrativeActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdministrativeActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdministrativeActionType> knownValues() {
        EnumSet<AdministrativeActionType> knownValues = EnumSet.allOf(AdministrativeActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdministrativeActionType.class, AdministrativeActionType::toString);
    }
}

