/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fsx.DefaultFSxBaseClientBuilder;
import software.amazon.awssdk.services.fsx.DefaultFSxClient;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.FSxClientBuilder;
import software.amazon.awssdk.services.fsx.FSxServiceClientConfiguration;
import software.amazon.awssdk.services.fsx.endpoints.FSxEndpointProvider;

@SdkInternalApi
final class DefaultFSxClientBuilder
extends DefaultFSxBaseClientBuilder<FSxClientBuilder, FSxClient>
implements FSxClientBuilder {
    DefaultFSxClientBuilder() {
    }

    @Override
    public DefaultFSxClientBuilder endpointProvider(FSxEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FSxClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFSxClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FSxServiceClientConfiguration serviceClientConfiguration = FSxServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFSxClient(serviceClientConfiguration, clientConfiguration);
    }
}

