/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse;

public class DescribeDataRepositoryAssociationsIterable
implements SdkIterable<DescribeDataRepositoryAssociationsResponse> {
    private final FSxClient client;
    private final DescribeDataRepositoryAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataRepositoryAssociationsIterable(FSxClient client, DescribeDataRepositoryAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataRepositoryAssociationsResponseFetcher();
    }

    public Iterator<DescribeDataRepositoryAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeDataRepositoryAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeDataRepositoryAssociationsResponse> {
        private DescribeDataRepositoryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataRepositoryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDataRepositoryAssociationsResponse nextPage(DescribeDataRepositoryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataRepositoryAssociationsIterable.this.client.describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsIterable.this.firstRequest);
            }
            return DescribeDataRepositoryAssociationsIterable.this.client.describeDataRepositoryAssociations((DescribeDataRepositoryAssociationsRequest)((Object)DescribeDataRepositoryAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

