/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceResponse;

public class ListTagsForResourceIterable
implements SdkIterable<ListTagsForResourceResponse> {
    private final FSxClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsForResourceIterable(FSxClient client, ListTagsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public Iterator<ListTagsForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTagsForResourceResponseFetcher
    implements SyncPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsForResourceResponse nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourceIterable.this.client.listTagsForResource(ListTagsForResourceIterable.this.firstRequest);
            }
            return ListTagsForResourceIterable.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

