/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse;

public class DescribeSnapshotsIterable
implements SdkIterable<DescribeSnapshotsResponse> {
    private final FSxClient client;
    private final DescribeSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSnapshotsIterable(FSxClient client, DescribeSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public Iterator<DescribeSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSnapshotsResponse nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsIterable.this.client.describeSnapshots(DescribeSnapshotsIterable.this.firstRequest);
            }
            return DescribeSnapshotsIterable.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

