/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.SecurityStyle;
import software.amazon.awssdk.services.fsx.model.TieringPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOntapVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JunctionPath").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::junctionPath)).setter(UpdateOntapVolumeConfiguration.setter(Builder::junctionPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()}).build();
    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityStyle").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::securityStyleAsString)).setter(UpdateOntapVolumeConfiguration.setter(Builder::securityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()}).build();
    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeInMegabytes").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::sizeInMegabytes)).setter(UpdateOntapVolumeConfiguration.setter(Builder::sizeInMegabytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()}).build();
    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEfficiencyEnabled").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::storageEfficiencyEnabled)).setter(UpdateOntapVolumeConfiguration.setter(Builder::storageEfficiencyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build()}).build();
    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TieringPolicy").getter(UpdateOntapVolumeConfiguration.getter(UpdateOntapVolumeConfiguration::tieringPolicy)).setter(UpdateOntapVolumeConfiguration.setter(Builder::tieringPolicy)).constructor(TieringPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD, SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, TIERING_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String junctionPath;
    private final String securityStyle;
    private final Integer sizeInMegabytes;
    private final Boolean storageEfficiencyEnabled;
    private final TieringPolicy tieringPolicy;

    private UpdateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.tieringPolicy = builder.tieringPolicy;
    }

    public final String junctionPath() {
        return this.junctionPath;
    }

    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(this.securityStyle);
    }

    public final String securityStyleAsString() {
        return this.securityStyle;
    }

    public final Integer sizeInMegabytes() {
        return this.sizeInMegabytes;
    }

    public final Boolean storageEfficiencyEnabled() {
        return this.storageEfficiencyEnabled;
    }

    public final TieringPolicy tieringPolicy() {
        return this.tieringPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOntapVolumeConfiguration)) {
            return false;
        }
        UpdateOntapVolumeConfiguration other = (UpdateOntapVolumeConfiguration)obj;
        return Objects.equals(this.junctionPath(), other.junctionPath()) && Objects.equals(this.securityStyleAsString(), other.securityStyleAsString()) && Objects.equals(this.sizeInMegabytes(), other.sizeInMegabytes()) && Objects.equals(this.storageEfficiencyEnabled(), other.storageEfficiencyEnabled()) && Objects.equals(this.tieringPolicy(), other.tieringPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOntapVolumeConfiguration").add("JunctionPath", (Object)this.junctionPath()).add("SecurityStyle", (Object)this.securityStyleAsString()).add("SizeInMegabytes", (Object)this.sizeInMegabytes()).add("StorageEfficiencyEnabled", (Object)this.storageEfficiencyEnabled()).add("TieringPolicy", (Object)this.tieringPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JunctionPath": {
                return Optional.ofNullable(clazz.cast(this.junctionPath()));
            }
            case "SecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.securityStyleAsString()));
            }
            case "SizeInMegabytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInMegabytes()));
            }
            case "StorageEfficiencyEnabled": {
                return Optional.ofNullable(clazz.cast(this.storageEfficiencyEnabled()));
            }
            case "TieringPolicy": {
                return Optional.ofNullable(clazz.cast(this.tieringPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((UpdateOntapVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String junctionPath;
        private String securityStyle;
        private Integer sizeInMegabytes;
        private Boolean storageEfficiencyEnabled;
        private TieringPolicy tieringPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOntapVolumeConfiguration model) {
            this.junctionPath(model.junctionPath);
            this.securityStyle(model.securityStyle);
            this.sizeInMegabytes(model.sizeInMegabytes);
            this.storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            this.tieringPolicy(model.tieringPolicy);
        }

        public final String getJunctionPath() {
            return this.junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return this.securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return this.sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return this.storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return this.tieringPolicy != null ? this.tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public UpdateOntapVolumeConfiguration build() {
            return new UpdateOntapVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateOntapVolumeConfiguration> {
        public Builder junctionPath(String var1);

        public Builder securityStyle(String var1);

        public Builder securityStyle(SecurityStyle var1);

        public Builder sizeInMegabytes(Integer var1);

        public Builder storageEfficiencyEnabled(Boolean var1);

        public Builder tieringPolicy(TieringPolicy var1);

        default public Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return this.tieringPolicy((TieringPolicy)((TieringPolicy.Builder)TieringPolicy.builder().applyMutation(tieringPolicy)).build());
        }
    }
}

