/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse;

public class DescribeVolumesIterable
implements SdkIterable<DescribeVolumesResponse> {
    private final FSxClient client;
    private final DescribeVolumesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVolumesIterable(FSxClient client, DescribeVolumesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public Iterator<DescribeVolumesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeVolumesResponseFetcher
    implements SyncPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVolumesResponse nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesIterable.this.client.describeVolumes(DescribeVolumesIterable.this.firstRequest);
            }
            return DescribeVolumesIterable.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

