/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsConfiguration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileSystemRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, DeleteFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DeleteFileSystemRequest.getter(DeleteFileSystemRequest::fileSystemId)).setter(DeleteFileSystemRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(DeleteFileSystemRequest.getter(DeleteFileSystemRequest::clientRequestToken)).setter(DeleteFileSystemRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DeleteFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WindowsConfiguration").getter(DeleteFileSystemRequest.getter(DeleteFileSystemRequest::windowsConfiguration)).setter(DeleteFileSystemRequest.setter(Builder::windowsConfiguration)).constructor(DeleteFileSystemWindowsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build()}).build();
    private static final SdkField<DeleteFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(DeleteFileSystemRequest.getter(DeleteFileSystemRequest::lustreConfiguration)).setter(DeleteFileSystemRequest.setter(Builder::lustreConfiguration)).constructor(DeleteFileSystemLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD));
    private final String fileSystemId;
    private final String clientRequestToken;
    private final DeleteFileSystemWindowsConfiguration windowsConfiguration;
    private final DeleteFileSystemLustreConfiguration lustreConfiguration;

    private DeleteFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final DeleteFileSystemWindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public final DeleteFileSystemLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemRequest)) {
            return false;
        }
        DeleteFileSystemRequest other = (DeleteFileSystemRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.windowsConfiguration(), other.windowsConfiguration()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFileSystemRequest").add("FileSystemId", (Object)this.fileSystemId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("WindowsConfiguration", (Object)this.windowsConfiguration()).add("LustreConfiguration", (Object)this.lustreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "WindowsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.windowsConfiguration()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemRequest, T> g) {
        return obj -> g.apply((DeleteFileSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String clientRequestToken;
        private DeleteFileSystemWindowsConfiguration windowsConfiguration;
        private DeleteFileSystemLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.clientRequestToken(model.clientRequestToken);
            this.windowsConfiguration(model.windowsConfiguration);
            this.lustreConfiguration(model.lustreConfiguration);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final DeleteFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return this.windowsConfiguration != null ? this.windowsConfiguration.toBuilder() : null;
        }

        public final void setWindowsConfiguration(DeleteFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder windowsConfiguration(DeleteFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final DeleteFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(DeleteFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder lustreConfiguration(DeleteFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileSystemRequest build() {
            return new DeleteFileSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFileSystemRequest> {
        public Builder fileSystemId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder windowsConfiguration(DeleteFileSystemWindowsConfiguration var1);

        default public Builder windowsConfiguration(Consumer<DeleteFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return this.windowsConfiguration((DeleteFileSystemWindowsConfiguration)((DeleteFileSystemWindowsConfiguration.Builder)DeleteFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)).build());
        }

        public Builder lustreConfiguration(DeleteFileSystemLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<DeleteFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((DeleteFileSystemLustreConfiguration)((DeleteFileSystemLustreConfiguration.Builder)DeleteFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

