/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceLimit {
    FILE_SYSTEM_COUNT("FILE_SYSTEM_COUNT"),
    TOTAL_THROUGHPUT_CAPACITY("TOTAL_THROUGHPUT_CAPACITY"),
    TOTAL_STORAGE("TOTAL_STORAGE"),
    TOTAL_USER_INITIATED_BACKUPS("TOTAL_USER_INITIATED_BACKUPS"),
    TOTAL_USER_TAGS("TOTAL_USER_TAGS"),
    TOTAL_IN_PROGRESS_COPY_BACKUPS("TOTAL_IN_PROGRESS_COPY_BACKUPS"),
    STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM("STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM"),
    VOLUMES_PER_FILE_SYSTEM("VOLUMES_PER_FILE_SYSTEM"),
    TOTAL_SSD_IOPS("TOTAL_SSD_IOPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceLimit> VALUE_MAP;
    private final String value;

    private ServiceLimit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceLimit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceLimit> knownValues() {
        EnumSet<ServiceLimit> knownValues = EnumSet.allOf(ServiceLimit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceLimit.class, ServiceLimit::toString);
    }
}

